/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.service.admin;

import com.cpi.framework.web.dao.admin.CodeGenerateDao;
import com.cpi.framework.web.entity.admin.CodeGenerateBean;
import com.cpi.framework.web.entity.admin.CodeGenerateParam;
import com.cpi.framework.web.entity.admin.FormField;
import com.cpi.framework.web.entity.admin.GridField;
import com.cpi.framework.web.entity.admin.OriginalColumns;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CodeGenerateService {
    @Autowired
    private CodeGenerateDao codeGenerateDao;

    public boolean checkTabExists(String tableName) {
        return Long.parseLong(this.codeGenerateDao.checkTabExists(tableName.toUpperCase()).toString()) > 0L;
    }

    public void gernerateToFile(CodeGenerateBean obj, Object contextPath, List<GridField> gridFieldList, List<FormField> formFieldList) throws IOException, ServletException {
        FileWriter out;
        File file;
        Template t;
        Configuration cfg = new Configuration();
        cfg.setServletContextForTemplateLoading(contextPath, "static/templete/");
        CodeGenerateParam param = new CodeGenerateParam();
        param.setBussiPackage("com.cpi");
        param.setTableName(obj.getTableName().toUpperCase());
        param.setTableComment(this.codeGenerateDao.getTableComment(obj.getTableName().toUpperCase()));
        param.setEntityPackage(obj.getPackgeName());
        param.setEntityName(this.tableToEntity(obj.getTableName().toLowerCase()));
        param.setPk(this.codeGenerateDao.getPK(obj.getTableName().toUpperCase()));
        param.setFtl_description(String.valueOf(param.getTableName()) + "-" + param.getTableComment());
        param.setFtl_create_time(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        List<OriginalColumns> columList = this.codeGenerateDao.findTableInfo(obj.getTableName().toUpperCase());
        param.setOriginalColumns(columList);
        if (obj.getHasEntity() != null && obj.getHasEntity().booleanValue()) {
            t = cfg.getTemplate("entityTemplate.ftl");
            file = this.newFile(obj, "/java/com/cpi/entity/", String.valueOf(param.getEntityName()) + ".java");
            out = new FileWriter(file);
            try {
                t.process((Object)param, (Writer)out);
            }
            catch (TemplateException e) {
                throw new ServletException("\u5904\u7406entityTemplate\u6a21\u7248\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
        if (obj.getHasDao() != null && obj.getHasDao().booleanValue()) {
            t = cfg.getTemplate("daoTemplate.ftl");
            file = this.newFile(obj, "/java/com/cpi/dao/jpa/framework/", String.valueOf(param.getEntityName()) + "Dao.java");
            out = new FileWriter(file);
            try {
                t.process((Object)param, (Writer)out);
            }
            catch (TemplateException e) {
                throw new ServletException("\u5904\u7406daoTemplate\u6a21\u7248\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
        if (obj.getHasService() != null && obj.getHasService().booleanValue()) {
            t = cfg.getTemplate("serviceTemplate.ftl");
            file = this.newFile(obj, "/java/com/cpi/service/", String.valueOf(param.getEntityName()) + "Service.java");
            out = new FileWriter(file);
            try {
                t.process((Object)param, (Writer)out);
            }
            catch (TemplateException e) {
                throw new ServletException("\u5904\u7406serviceTemplate\u6a21\u7248\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
        if (obj.getHasController() != null && obj.getHasController().booleanValue()) {
            t = cfg.getTemplate("controllerTemplate.ftl");
            file = this.newFile(obj, "/java/com/cpi/web/controller/", String.valueOf(param.getEntityName()) + "Controller.java");
            out = new FileWriter(file);
            try {
                t.process((Object)param, (Writer)out);
            }
            catch (TemplateException e) {
                throw new ServletException("\u5904\u7406controllerTemplate\u6a21\u7248\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
        if (obj.getHasGrid() != null && obj.getHasGrid().booleanValue()) {
            param.setFormFieldList(formFieldList);
            param.setGridFieldList(gridFieldList);
            t = cfg.getTemplate("gridTemplate.ftl");
            file = this.newFile(obj, "/webapp/static/js/", String.valueOf(param.getEntityName().substring(0, 1).toLowerCase()) + param.getEntityName().substring(1) + ".js");
            out = new FileWriter(file);
            try {
                t.process((Object)param, (Writer)out);
            }
            catch (TemplateException e) {
                throw new ServletException("\u5904\u7406controllerTemplate\u6a21\u7248\u4e2d\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            }
        }
    }

    private String tableToEntity(String tableName) {
        String[] strArr = tableName.toLowerCase().split("_");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < strArr.length) {
            sb.append(Character.toUpperCase(strArr[i].charAt(0)));
            sb.append(strArr[i].substring(1));
            ++i;
        }
        return sb.toString();
    }

    private File newFile(CodeGenerateBean obj, String filePath, String fileType) throws IOException {
        String fileName;
        File file;
        String dir = String.valueOf(obj.getPath()) + filePath + obj.getPackgeName();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        if (!(file = new File(fileName = String.valueOf(dir) + "/" + fileType)).exists()) {
            file.createNewFile();
        }
        return file;
    }

    public List<OriginalColumns> queryTableField(String tabName) {
        return this.codeGenerateDao.findTableInfo(tabName);
    }
}

