/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.service.admin;

import com.cpi.framework.dao.hibernate4.IHibernateBaseDao;
import com.cpi.framework.modules.persistence.Hibernates;
import com.cpi.framework.service.hibernate.BaseServiceImpl;
import com.cpi.framework.web.dao.admin.FwOrgPermissonsDao;
import com.cpi.framework.web.dao.admin.FwPermissonDao;
import com.cpi.framework.web.dao.admin.FwStationPermissonsDao;
import com.cpi.framework.web.dao.admin.FwUserDao;
import com.cpi.framework.web.dao.admin.FwUserPermissonsDao;
import com.cpi.framework.web.entity.admin.FwOrgPermissons;
import com.cpi.framework.web.entity.admin.FwStationPermissons;
import com.cpi.framework.web.entity.admin.FwUser;
import com.cpi.framework.web.entity.admin.FwUserPermissons;
import java.util.List;
import java.util.Set;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class AccountService
extends BaseServiceImpl<FwUser, Long> {
    public static final String HASH_ALGORITHM = "MD5";
    public static final int HASH_INTERATIONS = 2;
    public static final String HASH_SALT = "cpi";
    @Autowired
    private FwUserDao fwUserDao;
    @Autowired
    private FwUserPermissonsDao userPermissonsDao;
    @Autowired
    private FwStationPermissonsDao stationPermissonsDao;
    @Autowired
    private FwOrgPermissonsDao orgPermissonsDao;
    @Autowired
    private FwPermissonDao permissonDao;

    public List<FwUser> getAllUser() {
        return this.fwUserDao.loadAll();
    }

    public FwUser getUser(Long id) {
        return (FwUser)this.fwUserDao.get(id);
    }

    @Transactional(readOnly=true)
    public FwUser findUserByLoginCode(String loginCode) {
        List fwUserLs = this.fwUserDao.findByNamedParam("logincode", loginCode);
        if (fwUserLs != null && fwUserLs.size() > 0) {
            return (FwUser)fwUserLs.get(0);
        }
        return null;
    }

    @Transactional(readOnly=true)
    public List<FwUserPermissons> findUserPermissonsByUserId(Long userId) {
        return this.userPermissonsDao.findByNamedParam("userId", userId);
    }

    @Transactional(readOnly=true)
    public List<FwStationPermissons> findStationPermissonsByUserId(Long stId) {
        return this.stationPermissonsDao.findByNamedParam("stId", stId);
    }

    @Transactional(readOnly=true)
    public List<FwOrgPermissons> findOrgPermissonsByUserId(Long orgId) {
        return this.orgPermissonsDao.findByNamedParam("orgId", orgId);
    }

    @Transactional(readOnly=true)
    public List<String> findPermissonCodeByPermissonId(Set<Long> orgId) {
        return this.permissonDao.findByHQL("select permissonCode from FwPermissons where id in (" + orgId.toString().substring(1, orgId.toString().length() - 1) + ")");
    }

    @Transactional(readOnly=true)
    public FwUser findUserByNameInitialized(String loginCode) {
        FwUser user = this.findUserByLoginCode(loginCode);
        if (user != null) {
            Hibernates.initLazyProperty(user.getRoleList());
        }
        return user;
    }

    @Transactional(readOnly=true)
    public String getUserName(String userCode) {
        String result = "";
        FwUser fwUser = this.findUserByLoginCode(userCode);
        if (fwUser != null) {
            result = fwUser.getUsername();
        }
        return result;
    }

    public String entryptPassword(String plaintextPassword) {
        Md5Hash md5 = new Md5Hash((Object)plaintextPassword, (Object)HASH_SALT.getBytes(), 2);
        return md5.toString();
    }

    @Override
    public IHibernateBaseDao<FwUser, Long> getHibernateBaseDao() {
        return this.fwUserDao;
    }
}

