/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.controller;

import com.cpi.framework.modules.utils.AjaxUtil;
import com.cpi.framework.modules.utils.CustomDateEditor;
import com.cpi.framework.modules.utils.SecurityContextUtil;
import com.cpi.framework.web.common.ResponseData;
import com.cpi.framework.web.common.ShiroUser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public abstract class BaseController {
    public static final String EXCEPTION_MESSAGE = "EXCEPTION_MESSAGE";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ObjectMapper mapper = new ObjectMapper();

    public ShiroUser getCurUser() {
        return SecurityContextUtil.getCurrentUser();
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor(true));
    }

    @ExceptionHandler
    public void handleException(Exception exception, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.error(exception.getMessage(), (Throwable)exception);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        request.setAttribute(EXCEPTION_MESSAGE, (Object)exception);
        if (!AjaxUtil.isAjaxRequest(request)) {
            throw exception;
        }
        String errorMsg = exception.getMessage();
        errorMsg = StringUtils.isBlank((CharSequence)errorMsg) ? "" : errorMsg.replace("\r\n", "");
        StackTraceElement[] ste = exception.getStackTrace();
        StringBuffer detailmessage = new StringBuffer();
        int i = 0;
        while (i < ste.length) {
            detailmessage.append(ste[i]).append("\\t");
            ++i;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inftype", 2);
        map.put("showdetial", "");
        map.put("clientCode", errorMsg);
        map.put("message", "\u64cd\u4f5c\u5931\u8d25!!!");
        map.put("detailmessage", detailmessage);
        map.put("callback", "");
        ResponseData data = new ResponseData(false, map);
        data.setRequestURI(request.getRequestURI());
        data.setExecptionTrace(ExceptionUtils.getFullStackTrace((Throwable)exception));
        try {
            String json = this.mapper.writeValueAsString((Object)data);
            response.setContentType("text/html;charset=UTF-8");
            response.getWriter().write(json);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean fileUpload(HttpServletRequest request, String targetPath) {
        long startTime = System.currentTimeMillis();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
            Iterator ite = multiRequest.getFileNames();
            while (ite.hasNext()) {
                MultipartFile file = multiRequest.getFile((String)ite.next());
                if (file == null) continue;
                File localFile = new File(String.valueOf(targetPath.endsWith("/") ? targetPath : String.valueOf(targetPath) + "/") + file.getOriginalFilename());
                try {
                    file.transferTo(localFile);
                }
                catch (IllegalStateException e) {
                    this.logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25!", (Throwable)e);
                }
                catch (IOException e) {
                    this.logger.error("\u6587\u4ef6\u8bfb\u5199\u9519\u8bef!", (Throwable)e);
                }
            }
        }
        long endTime = System.currentTimeMillis();
        this.logger.info("\u4e0a\u4f20\u6587\u4ef6\u5171\u4f7f\u7528\u65f6\u95f4\uff1a" + (endTime - startTime));
        return true;
    }
}

