/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.common.mybatis.page;

import com.cpi.framework.web.common.mybatis.page.Pager;
import com.cpi.framework.web.common.mybatis.page.ReflectHelper;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.PropertyException;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.statement.BaseStatementHandler;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class})})
public class PagePlugin
implements Interceptor {
    private static String dialect = "";
    private static String pageSqlId = "";
    private static String DIALECT_STR = "dialect";
    private static final Logger logger = LoggerFactory.getLogger(PagePlugin.class);

    public Object intercept(Invocation ivk) throws Throwable {
        RoutingStatementHandler statementHandler;
        BaseStatementHandler delegate;
        MappedStatement mappedStatement;
        if (ivk.getTarget() instanceof RoutingStatementHandler && (mappedStatement = (MappedStatement)ReflectHelper.getValueByFieldName(delegate = (BaseStatementHandler)ReflectHelper.getValueByFieldName(statementHandler = (RoutingStatementHandler)ivk.getTarget(), "delegate"), "mappedStatement")).getId().matches(pageSqlId)) {
            BoundSql boundSql = delegate.getBoundSql();
            Object parameterObject = boundSql.getParameterObject();
            if (parameterObject == null) {
                throw new NullPointerException("parameterObject\u5c1a\u672a\u5b9e\u4f8b\u5316\uff01");
            }
            Connection connection = (Connection)ivk.getArgs()[0];
            String sql = boundSql.getSql();
            String countSql = "select count(0) as tmp_count from (" + sql + ") t";
            PreparedStatement countStmt = connection.prepareStatement(countSql);
            BoundSql countBS = new BoundSql(mappedStatement.getConfiguration(), countSql, boundSql.getParameterMappings(), parameterObject);
            this.setParameters(countStmt, mappedStatement, countBS, parameterObject);
            ResultSet rs = countStmt.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            countStmt.close();
            Pager page = null;
            if (parameterObject instanceof Pager) {
                page = (Pager)parameterObject;
                page.setTotal(count);
            } else if (parameterObject instanceof Map && !(parameterObject instanceof List)) {
                Map map = (Map)parameterObject;
                if (map.get("list") != null) {
                    List list = (List)map.get("list");
                    Object obj = list.get(0);
                    Field pageField = ReflectHelper.getFieldByFieldName(obj, "page");
                    if (pageField != null) {
                        page = (Pager)ReflectHelper.getValueByFieldName(obj, "page");
                        if (page == null) {
                            page = new Pager();
                        }
                    } else {
                        throw new NoSuchFieldException(String.valueOf(obj.getClass().getName()) + "\u4e0d\u5b58\u5728 page \u5c5e\u6027\uff01");
                    }
                    page.setTotal(count);
                    ReflectHelper.setValueByFileNameSup(obj, "page", page);
                    page.setTotal(count);
                    list.remove(0);
                    list.add(0, obj);
                } else {
                    page = (Pager)map.get("page");
                    page.setTotal(count);
                    map.remove("page");
                    map.put("page", page);
                }
            } else {
                Field pageField = ReflectHelper.getFieldByFieldName(parameterObject, "page");
                if (pageField != null) {
                    page = (Pager)ReflectHelper.getValueByFieldName(parameterObject, "page");
                    if (page == null) {
                        page = new Pager();
                    }
                    page.setTotal(count);
                    ReflectHelper.setValueByFileNameSup(parameterObject, "page", page);
                } else {
                    throw new NoSuchFieldException(String.valueOf(parameterObject.getClass().getName()) + "\u4e0d\u5b58\u5728 page \u5c5e\u6027\uff01");
                }
            }
            String pageSql = this.generatePageSql(sql, page);
            ReflectHelper.setValueByFieldName(boundSql, "sql", pageSql);
        }
        return ivk.proceed();
    }

    private void setParameters(PreparedStatement ps, MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject) throws SQLException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ErrorContext.instance().activity("setting parameters").object(mappedStatement.getParameterMap().getId());
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings != null) {
            Configuration configuration = mappedStatement.getConfiguration();
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            MetaObject metaObject = parameterObject == null ? null : configuration.newMetaObject(parameterObject);
            int i = 0;
            while (i < parameterMappings.size()) {
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() != ParameterMode.OUT) {
                    Object value;
                    String propertyName = parameterMapping.getProperty();
                    PropertyTokenizer prop = new PropertyTokenizer(propertyName);
                    if (parameterObject == null) {
                        value = null;
                    } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                        value = parameterObject;
                    } else if (boundSql.hasAdditionalParameter(propertyName)) {
                        value = boundSql.getAdditionalParameter(propertyName);
                    } else if (propertyName.startsWith("__frch_") && boundSql.hasAdditionalParameter(prop.getName())) {
                        value = boundSql.getAdditionalParameter(prop.getName());
                        if (value != null) {
                            value = configuration.newMetaObject(value).getValue(propertyName.substring(prop.getName().length()));
                        }
                    } else {
                        value = metaObject == null ? null : metaObject.getValue(propertyName);
                    }
                    TypeHandler typeHandler = parameterMapping.getTypeHandler();
                    if (typeHandler == null) {
                        throw new ExecutorException("There was no TypeHandler found for parameter " + propertyName + " of statement " + mappedStatement.getId());
                    }
                    typeHandler.setParameter(ps, i + 1, value, parameterMapping.getJdbcType());
                }
                ++i;
            }
        }
    }

    private String generatePageSql(String sql, Pager page) {
        if (page != null && PagePlugin.notEmpty(dialect)) {
            StringBuffer pageSql = new StringBuffer();
            if ("mysql".equals(dialect)) {
                pageSql.append(sql);
                pageSql.append(" limit " + page.getCurrentResult() + "," + page.getSize());
            } else if ("oracle".equals(dialect)) {
                pageSql.append("select * from (select tmp_tb.*,ROWNUM row_id from (");
                pageSql.append(sql);
                pageSql.append(")tmp_tb where ROWNUM<=");
                pageSql.append(page.getCurrentResult() + page.getSize());
                pageSql.append(") where row_id>");
                pageSql.append(page.getCurrentResult());
            }
            return pageSql.toString();
        }
        return sql;
    }

    public void setProperties(Properties p) {
        dialect = p.getProperty(DIALECT_STR);
        if (PagePlugin.isEmpty(dialect)) {
            try {
                throw new PropertyException("dialect property is not found!");
            }
            catch (PropertyException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (PagePlugin.isEmpty(pageSqlId = p.getProperty("pageSqlId"))) {
            try {
                throw new PropertyException("pageSqlId property is not found!");
            }
            catch (PropertyException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static boolean notEmpty(String s) {
        return s != null && !"".equals(s) && !"null".equals(s);
    }

    public static boolean isEmpty(String s) {
        return s == null || "".equals(s) || "null".equals(s);
    }

    public Object plugin(Object arg0) {
        return Plugin.wrap((Object)arg0, (Interceptor)this);
    }
}

