/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.common;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnumUtil {
    private static final Logger logger = LoggerFactory.getLogger(EnumUtil.class);

    public static <E extends Enum<E>> E valueOfEnum(Class<E> enumClass, String key) {
        Enum[] enums;
        if (enumClass == null) {
            throw new IllegalArgumentException("enumClass\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (key == null || "".equals(key)) {
            throw new IllegalArgumentException("key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Field keyField = FieldUtils.getField(enumClass, (String)"key", (boolean)true);
        Field valueField = FieldUtils.getField(enumClass, (String)"value", (boolean)true);
        if (keyField == null || valueField == null) {
            throw new IllegalArgumentException("enumClass\u4e2d\u6ca1\u6709key\u6216\u8005\u6ca1\u6709value\u5b57\u6bb5!");
        }
        Enum[] enumArray = enums = (Enum[])enumClass.getEnumConstants();
        int n = enums.length;
        int n2 = 0;
        while (n2 < n) {
            Enum e = enumArray[n2];
            String key_ = null;
            try {
                key_ = (String)FieldUtils.readField((Object)e, (String)"key", (boolean)true);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
                throw new RuntimeException(e1);
            }
            if (key_ != null && !"".equals(key_) && key_.equals(key)) {
                return (E)e;
            }
            ++n2;
        }
        return null;
    }

    public static <E extends Enum<E>> String valueOfString(Class<E> enumClass, String key) {
        Enum[] enums;
        if (enumClass == null) {
            throw new IllegalArgumentException("enumClass\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (key == null || "".equals(key)) {
            throw new IllegalArgumentException("key\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Field keyField = FieldUtils.getField(enumClass, (String)"key", (boolean)true);
        Field valueField = FieldUtils.getField(enumClass, (String)"value", (boolean)true);
        if (keyField == null || valueField == null) {
            throw new IllegalArgumentException("enumClass\u4e2d\u6ca1\u6709key\u6216\u8005\u6ca1\u6709value\u5b57\u6bb5!");
        }
        Enum[] enumArray = enums = (Enum[])enumClass.getEnumConstants();
        int n = enums.length;
        int n2 = 0;
        while (n2 < n) {
            Enum e = enumArray[n2];
            try {
                String key_ = (String)FieldUtils.readField((Object)e, (String)"key", (boolean)true);
                if (key_ != null && !"".equals(key_) && key_.equals(key)) {
                    return (String)FieldUtils.readField((Object)e, (String)"value", (boolean)true);
                }
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
                throw new RuntimeException(e1);
            }
            ++n2;
        }
        return null;
    }

    public static <E extends Enum<E>> Map<String, String> getEnumMap(Class<E> enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("enumClass\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Field keyField = FieldUtils.getField(enumClass, (String)"key", (boolean)true);
        Field valueField = FieldUtils.getField(enumClass, (String)"value", (boolean)true);
        if (keyField == null || valueField == null) {
            throw new IllegalArgumentException("enumClass\u4e2d\u6ca1\u6709key\u6216\u8005\u6ca1\u6709value\u5b57\u6bb5!");
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum e = enumArray[n2];
            try {
                String key_ = (String)FieldUtils.readField((Object)e, (String)"key", (boolean)true);
                String value_ = (String)FieldUtils.readField((Object)e, (String)"value", (boolean)true);
                map.put(key_, value_);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
                throw new RuntimeException(e1);
            }
            ++n2;
        }
        return map;
    }

    public static String toString(Enum<?> enumClass) {
        try {
            return String.valueOf(enumClass.ordinal()) + "," + enumClass.name() + "," + FieldUtils.readField(enumClass, (String)"key", (boolean)true) + "," + FieldUtils.readField(enumClass, (String)"value", (boolean)true);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
    }
}

