/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.web.common;

import com.cpi.framework.core.spring.SpringApplicationContextHolder;
import com.cpi.framework.web.entity.admin.FwDictionary;
import com.cpi.framework.web.service.admin.FwDictionaryService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class DictionaryHolder {
    private static CacheManager cacheManager;
    private static FwDictionaryService dictEntryService;
    private static final Logger logger;

    static {
        logger = LoggerFactory.getLogger(DictionaryHolder.class);
    }

    public static <T> void putDictionaries(String dictTypeCode, List<T> dictionaries) {
        if (cacheManager == null) {
            cacheManager = (CacheManager)SpringApplicationContextHolder.getBean("cacheManager");
        }
        if (dictionaries != null) {
            cacheManager.getCache("dicts").put((Object)dictTypeCode, dictionaries);
        }
    }

    public static <T> List<T> getDictionaries(String dictTypeCode) {
        Cache.ValueWrapper vw;
        if (cacheManager == null) {
            cacheManager = (CacheManager)SpringApplicationContextHolder.getBean("cacheManager");
        }
        if ((vw = cacheManager.getCache("dicts").get((Object)dictTypeCode)) == null) {
            return null;
        }
        ArrayList resultList = new ArrayList();
        resultList.addAll((Collection)vw.get());
        return resultList;
    }

    public static void cleanDictionaries(String dictTypeCode) {
        if (cacheManager == null) {
            cacheManager = (CacheManager)SpringApplicationContextHolder.getBean("cacheManager");
        }
        cacheManager.getCache("dicts").evict((Object)dictTypeCode);
    }

    public static <T> void transfercoder(List<T> list, String dictTypeCode, String getMethod) {
        if (dictEntryService == null) {
            dictEntryService = SpringApplicationContextHolder.getBean(FwDictionaryService.class);
        }
        if (cacheManager == null) {
            cacheManager = SpringApplicationContextHolder.getBean(CacheManager.class);
        }
        List<FwDictionary> dictionaries = null;
        Cache.ValueWrapper vw = cacheManager.getCache("dicts").get((Object)dictTypeCode);
        if (vw != null) {
            dictionaries = (List<FwDictionary>)vw.get();
        }
        if (dictionaries == null) {
            dictionaries = dictEntryService.queryDictionarys(dictTypeCode);
            cacheManager.getCache("dicts").put((Object)dictTypeCode, dictionaries);
        }
        String[] args = getMethod.split("\\.");
        int len = args.length;
        getMethod = args[len - 1];
        for (T t : list) {
            try {
                Object entity = t;
                int i = 0;
                while (i < len - 1) {
                    String name = StringUtils.capitalize((String)args[i]);
                    Method method = t.getClass().getMethod("get" + name, new Class[0]);
                    entity = method.invoke(t, new Object[0]);
                    ++i;
                }
                Method method = entity.getClass().getMethod(getMethod, new Class[0]);
                String obj = String.valueOf(method.invoke(entity, new Object[0]));
                String value = "";
                for (FwDictionary dic : dictionaries) {
                    if (!dic.getDicCode().equals(obj)) continue;
                    value = dic.getDicValue();
                    break;
                }
                if (!org.springframework.util.StringUtils.hasText((String)value)) continue;
                method = entity.getClass().getMethod(String.valueOf(getMethod.replace("get", "set")) + "_Name", String.class);
                method.invoke(entity, value);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static <T> void transfercoderForMap(List<Map<String, Object>> list, String dictTypeCode, String field) {
        if (dictEntryService == null) {
            dictEntryService = SpringApplicationContextHolder.getBean(FwDictionaryService.class);
        }
        if (cacheManager == null) {
            cacheManager = SpringApplicationContextHolder.getBean(CacheManager.class);
        }
        List<FwDictionary> dictionaries = null;
        Cache.ValueWrapper vw = cacheManager.getCache("dicts").get((Object)dictTypeCode);
        if (vw != null) {
            dictionaries = (List<FwDictionary>)vw.get();
        }
        if (dictionaries == null) {
            dictionaries = dictEntryService.queryDictionarys(dictTypeCode);
            cacheManager.getCache("dicts").put((Object)dictTypeCode, dictionaries);
        }
        for (Map<String, Object> map : list) {
            String key = String.valueOf(map.get(field));
            String value = "";
            for (FwDictionary dic : dictionaries) {
                if (!dic.getDicCode().equals(key)) continue;
                value = dic.getDicValue();
                break;
            }
            map.put(String.valueOf(field) + "_Name", value);
        }
    }
}

