/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.service.hibernate;

import com.cpi.framework.dao.hibernate4.IHibernateBaseDao;
import com.cpi.framework.dao.support.Pagination;
import com.cpi.framework.dao.support.PaginationRequest;
import com.cpi.framework.service.hibernate.BaseService;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.hibernate.criterion.Order;
import org.hibernate.engine.jdbc.LobCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseServiceImpl<T, ID extends Serializable>
implements BaseService<T, ID>,
InitializingBean {
    protected final Logger logger = LoggerFactory.getLogger(super.getClass());
    protected Class<T> entityClass;
    protected boolean isAssignableBaseEntity = false;

    public abstract IHibernateBaseDao<T, ID> getHibernateBaseDao();

    public void afterPropertiesSet() throws Exception {
        Type type = super.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            this.entityClass = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
    }

    @Override
    @Transactional(readOnly=true)
    public T getEntity(ID id) {
        return this.getHibernateBaseDao().get(id);
    }

    @Transactional(readOnly=true)
    public List<T> findAllEntity() {
        return this.getHibernateBaseDao().loadAll();
    }

    @Override
    @Transactional
    public ID insertEntity(T entity) {
        return this.getHibernateBaseDao().save(entity);
    }

    @Override
    @Transactional
    public void updateEntity(T entity) {
        this.getHibernateBaseDao().update(entity);
    }

    @Override
    @Transactional
    public void createOrUpdate(T entity) {
        this.getHibernateBaseDao().saveOrUpdate(entity);
    }

    @Override
    @Transactional
    public T deleteEntity(ID id) {
        return this.getHibernateBaseDao().delete(id);
    }

    @Override
    @Transactional
    public void bulkDeleteEntity(ID[] ids) {
        ID[] IDArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            ID id = IDArray[n2];
            this.deleteEntity(id);
            ++n2;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> loadEntities() {
        return this.getHibernateBaseDao().loadAll();
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParam(String propertyName, Object value) {
        return this.getHibernateBaseDao().findByNamedParam(propertyName, value);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParam(String[] propertyNames, Object[] values) {
        return this.getHibernateBaseDao().findByNamedParam(propertyNames, values);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParamAndOrder(String propertyName, Object value, Order order) {
        return this.getHibernateBaseDao().findByNamedParamAndOrder(propertyName, value, order);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParamAndOrder(String[] propertyNames, Object[] values, Order[] orders) {
        return this.getHibernateBaseDao().findByNamedParamAndOrder(propertyNames, values, orders);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParamAndOrder(String joinEntity, String propertyName, Object value, Order order) {
        return this.findByNamedParamAndOrder(new String[]{joinEntity}, propertyName, value, order);
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParamAndOrder(String[] joinEntitys, String propertyName, Object value, Order order) {
        return this.getHibernateBaseDao().findByNamedParamAndOrder(joinEntitys, new String[]{propertyName}, new Object[]{value}, new Order[]{order});
    }

    @Override
    @Transactional(readOnly=true)
    public List<T> findByNamedParamAndOrder(String[] joinEntitys, String[] propertyNames, Object[] values, Order order) {
        return this.getHibernateBaseDao().findByNamedParamAndOrder(joinEntitys, propertyNames, values, new Order[]{order});
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination<T> findPage(PaginationRequest<T> paginationRequest) {
        return this.getHibernateBaseDao().findPage(paginationRequest);
    }

    @Override
    public LobCreator getLobCreator() {
        return this.getHibernateBaseDao().getLobCreator();
    }
}

