/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.modules.web.taglib;

import java.util.Collection;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.tags.form.AbstractMultiCheckedElementTag;
import org.springframework.web.servlet.tags.form.TagWriter;

public abstract class BSAbstractMultiCheckedElementTag
extends AbstractMultiCheckedElementTag {
    private String labelCssClass;

    public void setLabelCssClass(String labelCssClass) {
        this.labelCssClass = labelCssClass;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        T[] items = this.getItems();
        T[] itemsObject = items instanceof String ? this.evaluate("items", items) : items;
        String itemValue = this.getItemValue();
        String itemLabel = this.getItemLabel();
        String valueProperty = itemValue != null ? ObjectUtils.getDisplayString((Object)this.evaluate("itemValue", itemValue)) : null;
        String labelProperty = itemLabel != null ? ObjectUtils.getDisplayString((Object)this.evaluate("itemLabel", itemLabel)) : null;
        Class boundType = this.getBindStatus().getValueType();
        if (itemsObject == null && boundType != null && boundType.isEnum()) {
            itemsObject = boundType.getEnumConstants();
        }
        if (itemsObject == null) {
            throw new IllegalArgumentException("Attribute 'items' is required and must be a Collection, an Array or a Map");
        }
        if (itemsObject.getClass().isArray()) {
            T[] itemsArray = itemsObject;
            int i = 0;
            while (i < itemsArray.length) {
                Object item = itemsArray[i];
                this.writeObjectEntry(tagWriter, valueProperty, labelProperty, item, i);
                ++i;
            }
        } else if (itemsObject instanceof Collection) {
            Collection optionCollection = (Collection)itemsObject;
            int itemIndex = 0;
            for (Object item : optionCollection) {
                this.writeObjectEntry(tagWriter, valueProperty, labelProperty, item, itemIndex);
                ++itemIndex;
            }
        } else if (itemsObject instanceof Map) {
            Map optionMap = (Map)itemsObject;
            int itemIndex = 0;
            for (Map.Entry entry : optionMap.entrySet()) {
                this.writeMapEntry(tagWriter, valueProperty, labelProperty, entry, itemIndex);
                ++itemIndex;
            }
        } else {
            throw new IllegalArgumentException("Attribute 'items' must be an array, a Collection or a Map");
        }
        return 0;
    }

    private void writeObjectEntry(TagWriter tagWriter, String valueProperty, String labelProperty, Object item, int itemIndex) throws JspException {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)item);
        Object renderValue = valueProperty != null ? wrapper.getPropertyValue(valueProperty) : (item instanceof Enum ? ((Enum)item).name() : item);
        Object renderLabel = labelProperty != null ? wrapper.getPropertyValue(labelProperty) : item;
        this.writeElementTag(tagWriter, item, renderValue, renderLabel, itemIndex);
    }

    private void writeMapEntry(TagWriter tagWriter, String valueProperty, String labelProperty, Map.Entry entry, int itemIndex) throws JspException {
        Object mapKey = entry.getKey();
        Object mapValue = entry.getValue();
        BeanWrapper mapKeyWrapper = PropertyAccessorFactory.forBeanPropertyAccess(mapKey);
        BeanWrapper mapValueWrapper = PropertyAccessorFactory.forBeanPropertyAccess(mapValue);
        Object renderValue = valueProperty != null ? mapKeyWrapper.getPropertyValue(valueProperty) : mapKey.toString();
        Object renderLabel = labelProperty != null ? mapValueWrapper.getPropertyValue(labelProperty) : mapValue.toString();
        this.writeElementTag(tagWriter, mapKey, renderValue, renderLabel, itemIndex);
    }

    private void writeElementTag(TagWriter tagWriter, Object item, Object value, Object label, int itemIndex) throws JspException {
        Object resolvedDelimiter;
        String id = this.resolveId();
        String resolvedLabelClass = this.getInputType();
        if (this.labelCssClass != null) {
            resolvedLabelClass = String.valueOf(resolvedLabelClass) + " " + this.labelCssClass;
        }
        tagWriter.startTag("label");
        tagWriter.writeAttribute("for", id);
        tagWriter.writeAttribute("class", resolvedLabelClass);
        if (itemIndex > 0 && (resolvedDelimiter = this.evaluate("delimiter", this.getDelimiter())) != null) {
            tagWriter.appendValue(resolvedDelimiter.toString());
        }
        tagWriter.startTag("input");
        this.writeOptionalAttribute(tagWriter, "id", id);
        this.writeOptionalAttribute(tagWriter, "name", this.getName());
        this.writeOptionalAttributes(tagWriter);
        tagWriter.writeAttribute("type", this.getInputType());
        this.renderFromValue(item, value, tagWriter);
        tagWriter.endTag();
        tagWriter.appendValue(this.convertToDisplayString(label));
        tagWriter.endTag();
    }
}

