/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.modules.utils;

import java.util.Date;

public interface Clock {
    public static final Clock DEFAULT = new DefaultClock();

    public Date getCurrentDate();

    public long getCurrentTimeInMillis();

    public static class DefaultClock
    implements Clock {
        @Override
        public Date getCurrentDate() {
            return new Date();
        }

        @Override
        public long getCurrentTimeInMillis() {
            return System.currentTimeMillis();
        }
    }

    public static class MockClock
    implements Clock {
        private long time;

        public MockClock() {
            this(0L);
        }

        public MockClock(Date date) {
            this.time = date.getTime();
        }

        public MockClock(long time) {
            this.time = time;
        }

        @Override
        public Date getCurrentDate() {
            return new Date(this.time);
        }

        @Override
        public long getCurrentTimeInMillis() {
            return this.time;
        }

        public void update(Date newDate) {
            this.time = newDate.getTime();
        }

        public void update(long newTime) {
            this.time = newTime;
        }

        public void increaseTime(int millis) {
            this.time += (long)millis;
        }

        public void decreaseTime(int millis) {
            this.time -= (long)millis;
        }
    }
}

