/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.modules.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AjaxUtil {
    public static boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("X-Requested-With");
        return requestedWith != null ? "XMLHttpRequest".equals(requestedWith) : false;
    }

    public static Map getParameterMap(HttpServletRequest request) {
        HashMap<String, Object> paraMap = new HashMap<String, Object>();
        Map reqParams = request.getParameterMap();
        Set entries = reqParams.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            String[] value = (String[])entry.getValue();
            if (value == null) continue;
            if (value.length == 1) {
                paraMap.put(name, value[0]);
                continue;
            }
            paraMap.put(name, value);
        }
        return paraMap;
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip.equals("0:0:0:0:0:0:0:1")) {
            ip = "\u672c\u5730";
        }
        return ip;
    }

    public static String getAppbaseUrl(HttpServletRequest request, String url) {
        return String.valueOf(request.getContextPath()) + url;
    }
}

