/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.modules.persistence;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SearchFilter {
    public String fieldName;
    public Object value;
    public Operator operator;

    public SearchFilter(String fieldName, Operator operator, Object value) {
        this.fieldName = fieldName;
        this.value = value;
        this.operator = operator;
    }

    public static Map<String, SearchFilter> parse(Map<String, Object> searchParams) {
        HashMap filters = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : searchParams.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (StringUtils.isBlank((CharSequence)((String)value))) continue;
            String[] names = StringUtils.split((String)key, (String)"_");
            if (names.length != 2) {
                throw new IllegalArgumentException(String.valueOf(key) + " is not a valid search filter name");
            }
            String filedName = names[1];
            Operator operator = Operator.valueOf(names[0]);
            SearchFilter filter = new SearchFilter(filedName, operator, value);
            filters.put(key, filter);
        }
        return filters;
    }

    public static enum Operator {
        EQ,
        LIKE,
        GT,
        LT,
        GTE,
        LTE;

    }
}

