/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.modules.persistence;

import com.cpi.framework.modules.persistence.SearchFilter;
import com.cpi.framework.modules.utils.Collections3;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class DynamicSpecifications {
    public static <T> Specification<T> bySearchFilter(final Collection<SearchFilter> filters, Class<T> entityClazz) {
        return new Specification<T>(){

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
                if (Collections3.isNotEmpty(filters)) {
                    ArrayList predicates = Lists.newArrayList();
                    for (SearchFilter filter : filters) {
                        String[] names = StringUtils.split((String)filter.fieldName, (String)".");
                        Path expression = root.get(names[0]);
                        int i = 1;
                        while (i < names.length) {
                            expression = expression.get(names[i]);
                            ++i;
                        }
                        switch (filter.operator) {
                            case EQ: {
                                predicates.add(builder.equal((Expression)expression, filter.value));
                                break;
                            }
                            case LIKE: {
                                predicates.add(builder.like((Expression)expression, "%" + filter.value + "%"));
                                break;
                            }
                            case GT: {
                                predicates.add(builder.greaterThan((Expression)expression, (Comparable)filter.value));
                                break;
                            }
                            case LT: {
                                predicates.add(builder.lessThan((Expression)expression, (Comparable)filter.value));
                                break;
                            }
                            case GTE: {
                                predicates.add(builder.greaterThanOrEqualTo((Expression)expression, (Comparable)filter.value));
                                break;
                            }
                            case LTE: {
                                predicates.add(builder.lessThanOrEqualTo((Expression)expression, (Comparable)filter.value));
                            }
                        }
                    }
                    if (!predicates.isEmpty()) {
                        return builder.and(predicates.toArray(new Predicate[predicates.size()]));
                    }
                }
                return builder.conjunction();
            }
        };
    }
}

