/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.dao.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Pagination<E>
implements Serializable,
Iterable<E> {
    private static final long serialVersionUID = 1L;
    protected List<E> result;
    private int offset;
    protected int limit;
    protected long currPage;
    protected long totalPages;
    protected long totalRecords = 0L;

    public Pagination(long totalPages, int offset, int limit, long totalRecords) {
        this(totalPages, offset, limit, totalRecords, new ArrayList(0));
    }

    public Pagination(long totalPages, int offset, int limit, long totalRecords, List<E> result) {
        this(offset / limit + 1, totalPages, offset, limit, totalRecords, result);
    }

    public Pagination(int currPage, long totalPages, int offset, int limit, long totalRecords, List<E> result) {
        if (limit <= 0) {
            throw new IllegalArgumentException("[pageSize] must great than zero");
        }
        this.limit = limit;
        this.offset = offset;
        this.currPage = currPage;
        this.totalPages = totalPages == 0L ? 1L : totalPages;
        this.totalRecords = totalRecords;
        this.setResult(result);
    }

    public void setResult(List<E> elements) {
        if (elements == null) {
            throw new IllegalArgumentException("'result' must be not null");
        }
        this.result = elements;
    }

    @JsonIgnore
    public int getOffset() {
        return this.offset;
    }

    @JsonIgnore
    public int getLimit() {
        return this.limit;
    }

    @JsonProperty(value="rows")
    public List<E> getResult() {
        return this.result;
    }

    @JsonIgnore
    public long getCurrPage() {
        return this.currPage;
    }

    @JsonIgnore
    public long getTotalPages() {
        return this.totalPages;
    }

    @JsonProperty(value="total")
    public long getTotalRecords() {
        return this.totalRecords;
    }

    @Override
    public Iterator<E> iterator() {
        return this.result == null ? null : this.result.iterator();
    }
}

