/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.dao.hibernate4;

import com.cpi.framework.modules.exception.DBAccessException;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class HibernateNativeDAO {
    @Autowired
    private SessionFactory sessionFactory;

    public Object getSingal(String queryString) {
        Session session = this.sessionFactory.getCurrentSession();
        SQLQuery query = session.createSQLQuery(queryString);
        List list = query.list();
        if (list != null && list.size() > 0) {
            Object o = list.get(0);
            return o;
        }
        return null;
    }

    public Object getSingal(String queryString, Object[] params) {
        List list;
        Session session = this.sessionFactory.getCurrentSession();
        SQLQuery query = session.createSQLQuery(queryString);
        if (params != null && params.length > 0) {
            int i = 0;
            while (i < params.length) {
                query.setParameter(i, params[i]);
                ++i;
            }
        }
        if ((list = query.list()) != null && list.size() > 0) {
            Object o = list.get(0);
            return o;
        }
        return null;
    }

    public <T> T getSingal(String queryString, Object[] params, Class type) {
        List list;
        Session session = this.sessionFactory.getCurrentSession();
        SQLQuery query = session.createSQLQuery(queryString).addEntity(type);
        if (params != null && params.length > 0) {
            int i = 0;
            while (i < params.length) {
                query.setParameter(i, params[i]);
                ++i;
            }
        }
        if ((list = query.list()) != null && list.size() > 0) {
            Object o = list.get(0);
            return (T)o;
        }
        return null;
    }

    public List findByNativeSQL(String queryString, int ... rowStartIdxAndCount) {
        Session session = null;
        try {
            session = this.sessionFactory.getCurrentSession();
            SQLQuery query = session.createSQLQuery(queryString);
            if (rowStartIdxAndCount != null && rowStartIdxAndCount.length > 0) {
                int rowCount;
                int rowStartIdx = Math.max(0, rowStartIdxAndCount[0]);
                if (rowStartIdx > 0) {
                    query.setFirstResult(rowStartIdx);
                }
                if (rowStartIdxAndCount.length > 1 && (rowCount = Math.max(0, rowStartIdxAndCount[1])) > 0) {
                    query.setMaxResults(rowCount);
                }
            }
            return query.list();
        }
        catch (HibernateException e) {
            throw new DBAccessException(e.getMessage(), e);
        }
    }

    public <T> List<T> findByNativeSQL(String queryString, Class type, int ... rowStartIdxAndCount) {
        Session session = this.sessionFactory.getCurrentSession();
        SQLQuery query = session.createSQLQuery(queryString).addEntity(type);
        if (rowStartIdxAndCount != null && rowStartIdxAndCount.length > 0) {
            int rowCount;
            int rowStartIdx = Math.max(0, rowStartIdxAndCount[0]);
            if (rowStartIdx > 0) {
                query.setFirstResult(rowStartIdx);
            }
            if (rowStartIdxAndCount.length > 1 && (rowCount = Math.max(0, rowStartIdxAndCount[1])) > 0) {
                query.setMaxResults(rowCount);
            }
        }
        List list = query.list();
        return list;
    }

    public List findByNativeSQL(String queryString, Object[] params, int ... rowStartIdxAndCount) {
        Session session = null;
        try {
            session = this.sessionFactory.getCurrentSession();
            SQLQuery query = session.createSQLQuery(queryString);
            if (params != null && params.length > 0) {
                int i = 0;
                while (i < params.length) {
                    query.setParameter(i, params[i]);
                    ++i;
                }
            }
            if (rowStartIdxAndCount != null && rowStartIdxAndCount.length > 0) {
                int rowCount;
                int rowStartIdx = Math.max(0, rowStartIdxAndCount[0]);
                if (rowStartIdx > 0) {
                    query.setFirstResult(rowStartIdx);
                }
                if (rowStartIdxAndCount.length > 1 && (rowCount = Math.max(0, rowStartIdxAndCount[1])) > 0) {
                    query.setMaxResults(rowCount);
                }
            }
            List list = query.list();
            return list;
        }
        catch (HibernateException e) {
            throw new DBAccessException(e.getMessage(), e);
        }
    }

    public <T> List<T> findByNativeSQL(String queryString, Object[] params, Class type) {
        Session session = null;
        try {
            session = this.sessionFactory.getCurrentSession();
            SQLQuery query = session.createSQLQuery(queryString);
            query.setResultTransformer(Transformers.aliasToBean((Class)type));
            if (params != null && params.length > 0) {
                int i = 0;
                while (i < params.length) {
                    query.setParameter(i, params[i]);
                    ++i;
                }
            }
            List list = query.list();
            return list;
        }
        catch (HibernateException e) {
            throw new DBAccessException(e.getMessage(), e);
        }
    }

    public <T> List<T> findByNativeSQL(String queryString, Object[] params, Class type, int ... rowStartIdxAndCount) {
        Session session = null;
        try {
            session = this.sessionFactory.getCurrentSession();
            SQLQuery query = session.createSQLQuery(queryString);
            query.setResultTransformer(Transformers.aliasToBean((Class)type));
            if (params != null && params.length > 0) {
                int i = 0;
                while (i < params.length) {
                    query.setParameter(i, params[i]);
                    ++i;
                }
            }
            if (rowStartIdxAndCount != null && rowStartIdxAndCount.length > 0) {
                int rowCount;
                int rowStartIdx = Math.max(0, rowStartIdxAndCount[0]);
                if (rowStartIdx > 0) {
                    query.setFirstResult(rowStartIdx);
                }
                if (rowStartIdxAndCount.length > 1 && (rowCount = Math.max(0, rowStartIdxAndCount[1])) > 0) {
                    query.setMaxResults(rowCount);
                }
            }
            List list = query.list();
            return list;
        }
        catch (HibernateException e) {
            throw new DBAccessException(e.getMessage(), e);
        }
    }

    public List findMapsByNativeSQL(String queryString) {
        Session session = null;
        try {
            session = this.sessionFactory.getCurrentSession();
            SQLQuery query = session.createSQLQuery(queryString);
            query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
            return query.list();
        }
        catch (HibernateException e) {
            throw new DBAccessException(e.getMessage(), e);
        }
    }

    @Transactional
    public void exeNativeSQL(String sql) {
        Session session = this.sessionFactory.getCurrentSession();
        SQLQuery query = session.createSQLQuery(sql);
        query.executeUpdate();
    }

    @Transactional
    public int exeNativeSQL(String sql, Object[] params) {
        Session session = this.sessionFactory.getCurrentSession();
        SQLQuery query = session.createSQLQuery(sql);
        if (params != null && params.length > 0) {
            int i = 0;
            while (i < params.length) {
                query.setParameter(i, params[i]);
                ++i;
            }
        }
        return query.executeUpdate();
    }

    @Transactional
    public boolean exeNativeSQL(List<String> sqls) {
        Session session = this.sessionFactory.getCurrentSession();
        for (String sql : sqls) {
            SQLQuery query = session.createSQLQuery(sql);
            query.executeUpdate();
        }
        session.flush();
        return true;
    }
}

