/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.framework.core.cache;

import com.cpi.framework.core.cache.CacheTypeEnum;
import com.cpi.framework.core.cache.JCSCacheCacheManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.io.ResourceUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.cache.concurrent.ConcurrentMapCacheFactoryBean;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.core.RedisTemplate;

public class CacheManagerFactoryBean
implements FactoryBean<org.springframework.cache.CacheManager>,
InitializingBean,
DisposableBean {
    @Value(value="${cache.type}")
    private String cacheType;
    @Autowired(required=false)
    private RedisTemplate<?, ?> redisTemplate;
    private org.springframework.cache.CacheManager cacheManager;
    private String configFile;

    public void afterPropertiesSet() throws Exception {
        switch (CacheTypeEnum.valueOf(this.cacheType.trim().toUpperCase())) {
            case SIMPLE: {
                this.cacheManager = this.createSimpleCacheManager();
                break;
            }
            case REDIS: {
                this.cacheManager = this.createRedisCacheManager();
                break;
            }
            case EHCACHE: {
                this.configFile = "classpath:cache/ehcache/ehcache.xml";
                this.cacheManager = this.createEhcaheCacheManager();
                break;
            }
            case JCS: {
                this.configFile = "classpath:cache/jcs/cache.ccf";
                this.cacheManager = this.createJCSCacheManager();
                break;
            }
            default: {
                throw new IllegalArgumentException("cacheType\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u8ba4\u5728properties\u6587\u4ef6\u4e2d\u914d\u7f6ecache.type\uff0c\u53ef\u9009\u503c\u4e3a\uff1asimple,redis \u6216 ehcache");
            }
        }
    }

    private org.springframework.cache.CacheManager createSimpleCacheManager() {
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        String[] names = new String[]{"resouces", "dicts"};
        ArrayList<ConcurrentMapCache> caches = new ArrayList<ConcurrentMapCache>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String cacheName = stringArray[n2];
            ConcurrentMapCacheFactoryBean factoryBean = new ConcurrentMapCacheFactoryBean();
            factoryBean.setName(cacheName);
            factoryBean.afterPropertiesSet();
            caches.add(factoryBean.getObject());
            ++n2;
        }
        cacheManager.setCaches(caches);
        cacheManager.afterPropertiesSet();
        return cacheManager;
    }

    private org.springframework.cache.CacheManager createRedisCacheManager() {
        if (this.redisTemplate == null) {
            throw new IllegalArgumentException("redisTemplate bean \u6ca1\u6709\u914d\u7f6e, \u65e0\u6cd5\u4f7f\u7528redis cache");
        }
        return new RedisCacheManager(this.redisTemplate);
    }

    private org.springframework.cache.CacheManager createEhcaheCacheManager() {
        try {
            return new EhCacheCacheManager(new CacheManager(this.getCacheManagerConfigFileInputStream()));
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private InputStream getCacheManagerConfigFileInputStream() {
        try {
            return ResourceUtils.getInputStreamForPath((String)this.configFile);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to obtain input stream for cacheManagerConfigFile [" + this.configFile + "]", (Throwable)e);
        }
    }

    protected org.springframework.cache.CacheManager createJCSCacheManager() {
        try {
            CompositeCacheManager cacheManager;
            Properties configProperties = this.getConfigProperties();
            if (configProperties == null) {
                cacheManager = CompositeCacheManager.getInstance();
            } else {
                cacheManager = CompositeCacheManager.getUnconfiguredInstance();
                cacheManager.configure(configProperties);
            }
            return new JCSCacheCacheManager(cacheManager);
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private Properties getConfigProperties() throws IOException {
        Properties properties = null;
        properties = new Properties();
        properties.load(this.getCacheManagerConfigFileInputStream());
        return properties;
    }

    public org.springframework.cache.CacheManager getObject() throws Exception {
        return this.cacheManager;
    }

    public Class<org.springframework.cache.CacheManager> getObjectType() {
        return org.springframework.cache.CacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.cacheManager != null) {
            if (this.cacheManager instanceof CacheManager) {
                ((CacheManager)this.cacheManager).shutdown();
            }
            if (this.cacheManager instanceof CompositeCacheManager) {
                ((CompositeCacheManager)this.cacheManager).shutDown();
            }
        }
    }
}

