/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.utils;

import java.util.Map;
import java.util.Properties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public class PropertiesUtil {
    public static Properties getPropertiesWithPrefix(Environment environment, String prefix) {
        return PropertiesUtil.handleSpringBinder(environment, prefix, Properties.class);
    }

    public static Map<String, Object> getPropertiesWithPrefixForMap(Environment environment, String prefix) {
        return PropertiesUtil.handleSpringBinder(environment, prefix, Map.class);
    }

    public static <T> T handleSpringBinder(Environment environment, String prefix, Class<T> targetClass) {
        String prefixParam = prefix.endsWith(".") ? prefix.substring(0, prefix.length() - 1) : prefix;
        return (T)Binder.get((Environment)environment).bind(prefixParam, Bindable.of(targetClass)).orElse(null);
    }
}

