/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.autoconfigure;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import tech.powerjob.common.enums.Protocol;
import tech.powerjob.worker.common.constants.StoreStrategy;

@ConfigurationProperties(prefix="powerjob")
public class PowerJobProperties {
    private final Worker worker = new Worker();

    public Worker getWorker() {
        return this.worker;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.app-name")
    public String getAppName() {
        return this.getWorker().appName;
    }

    @Deprecated
    public void setAppName(String appName) {
        this.getWorker().setAppName(appName);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.akka-port")
    public int getAkkaPort() {
        return this.getWorker().akkaPort;
    }

    @Deprecated
    public void setAkkaPort(int akkaPort) {
        this.getWorker().setAkkaPort(akkaPort);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.server-address")
    public String getServerAddress() {
        return this.getWorker().serverAddress;
    }

    @Deprecated
    public void setServerAddress(String serverAddress) {
        this.getWorker().setServerAddress(serverAddress);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.store-strategy")
    public StoreStrategy getStoreStrategy() {
        return this.getWorker().storeStrategy;
    }

    @Deprecated
    public void setStoreStrategy(StoreStrategy storeStrategy) {
        this.getWorker().setStoreStrategy(storeStrategy);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.max-result-length")
    public int getMaxResultLength() {
        return this.getWorker().maxResultLength;
    }

    @Deprecated
    public void setMaxResultLength(int maxResultLength) {
        this.getWorker().setMaxResultLength(maxResultLength);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(replacement="powerjob.worker.allow-lazy-connect-server")
    public boolean isEnableTestMode() {
        return this.getWorker().isAllowLazyConnectServer();
    }

    @Deprecated
    public void setEnableTestMode(boolean enableTestMode) {
        this.getWorker().setAllowLazyConnectServer(enableTestMode);
    }

    public static class Worker {
        private boolean enabled = true;
        private String appName;
        @Deprecated
        private int akkaPort = 27777;
        private Integer port;
        private String serverAddress;
        private Protocol protocol = Protocol.AKKA;
        private StoreStrategy storeStrategy = StoreStrategy.DISK;
        private int maxResultLength = 8192;
        private boolean allowLazyConnectServer = false;
        private int maxAppendedWfContextLength = 8192;
        private String tag;
        private Integer maxLightweightTaskNum = 1024;
        private Integer maxHeavyweightTaskNum = 64;
        private Integer healthReportInterval = 10;

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        @Deprecated
        public void setAkkaPort(int akkaPort) {
            this.akkaPort = akkaPort;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public void setServerAddress(String serverAddress) {
            this.serverAddress = serverAddress;
        }

        public void setProtocol(Protocol protocol) {
            this.protocol = protocol;
        }

        public void setStoreStrategy(StoreStrategy storeStrategy) {
            this.storeStrategy = storeStrategy;
        }

        public void setMaxResultLength(int maxResultLength) {
            this.maxResultLength = maxResultLength;
        }

        public void setAllowLazyConnectServer(boolean allowLazyConnectServer) {
            this.allowLazyConnectServer = allowLazyConnectServer;
        }

        public void setMaxAppendedWfContextLength(int maxAppendedWfContextLength) {
            this.maxAppendedWfContextLength = maxAppendedWfContextLength;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public void setMaxLightweightTaskNum(Integer maxLightweightTaskNum) {
            this.maxLightweightTaskNum = maxLightweightTaskNum;
        }

        public void setMaxHeavyweightTaskNum(Integer maxHeavyweightTaskNum) {
            this.maxHeavyweightTaskNum = maxHeavyweightTaskNum;
        }

        public void setHealthReportInterval(Integer healthReportInterval) {
            this.healthReportInterval = healthReportInterval;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getAppName() {
            return this.appName;
        }

        @Deprecated
        public int getAkkaPort() {
            return this.akkaPort;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getServerAddress() {
            return this.serverAddress;
        }

        public Protocol getProtocol() {
            return this.protocol;
        }

        public StoreStrategy getStoreStrategy() {
            return this.storeStrategy;
        }

        public int getMaxResultLength() {
            return this.maxResultLength;
        }

        public boolean isAllowLazyConnectServer() {
            return this.allowLazyConnectServer;
        }

        public int getMaxAppendedWfContextLength() {
            return this.maxAppendedWfContextLength;
        }

        public String getTag() {
            return this.tag;
        }

        public Integer getMaxLightweightTaskNum() {
            return this.maxLightweightTaskNum;
        }

        public Integer getMaxHeavyweightTaskNum() {
            return this.maxHeavyweightTaskNum;
        }

        public Integer getHealthReportInterval() {
            return this.healthReportInterval;
        }
    }
}

