/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin.efm2;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class MonitorConnectionContext {
    private final AtomicReference<WeakReference<Connection>> connectionToAbortRef;
    private final AtomicBoolean nodeUnhealthy = new AtomicBoolean(false);

    public MonitorConnectionContext(Connection connectionToAbort) {
        this.connectionToAbortRef = new AtomicReference<WeakReference<Connection>>(new WeakReference<Connection>(connectionToAbort));
    }

    public boolean isNodeUnhealthy() {
        return this.nodeUnhealthy.get();
    }

    void setNodeUnhealthy(boolean nodeUnhealthy) {
        this.nodeUnhealthy.set(nodeUnhealthy);
    }

    public boolean shouldAbort() {
        return this.nodeUnhealthy.get() && this.connectionToAbortRef.get() != null;
    }

    public void setInactive() {
        this.connectionToAbortRef.set(null);
    }

    public Connection getConnection() {
        WeakReference<Connection> copy = this.connectionToAbortRef.get();
        return copy == null ? null : (Connection)copy.get();
    }

    public boolean isActive() {
        WeakReference<Connection> copy = this.connectionToAbortRef.get();
        return copy != null && copy.get() != null;
    }
}

