/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.jdbc.plugin;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import software.amazon.awssdk.services.secretsmanager.model.SecretsManagerException;
import software.amazon.awssdk.utils.Pair;
import software.amazon.jdbc.AwsWrapperProperty;
import software.amazon.jdbc.HostSpec;
import software.amazon.jdbc.JdbcCallable;
import software.amazon.jdbc.PluginService;
import software.amazon.jdbc.PropertyDefinition;
import software.amazon.jdbc.authentication.AwsCredentialsManager;
import software.amazon.jdbc.plugin.AbstractConnectionPlugin;
import software.amazon.jdbc.util.Messages;
import software.amazon.jdbc.util.RegionUtils;
import software.amazon.jdbc.util.StringUtils;
import software.amazon.jdbc.util.telemetry.TelemetryContext;
import software.amazon.jdbc.util.telemetry.TelemetryCounter;
import software.amazon.jdbc.util.telemetry.TelemetryFactory;
import software.amazon.jdbc.util.telemetry.TelemetryTraceLevel;

public class AwsSecretsManagerConnectionPlugin
extends AbstractConnectionPlugin {
    private static final Logger LOGGER = Logger.getLogger(AwsSecretsManagerConnectionPlugin.class.getName());
    private static final String TELEMETRY_UPDATE_SECRETS = "fetch credentials";
    private static final String TELEMETRY_FETCH_CREDENTIALS_COUNTER = "secretsManager.fetchCredentials.count";
    private static final Set<String> subscribedMethods = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("connect");
            this.add("forceConnect");
        }
    });
    public static final AwsWrapperProperty SECRET_ID_PROPERTY = new AwsWrapperProperty("secretsManagerSecretId", null, "The name or the ARN of the secret to retrieve.");
    public static final AwsWrapperProperty REGION_PROPERTY = new AwsWrapperProperty("secretsManagerRegion", "us-east-1", "The region of the secret to retrieve.");
    public static final AwsWrapperProperty ENDPOINT_PROPERTY = new AwsWrapperProperty("secretsManagerEndpoint", null, "The endpoint of the secret to retrieve.");
    protected static final RegionUtils regionUtils = new RegionUtils();
    protected static final Map<Pair<String, Region>, Secret> secretsCache = new ConcurrentHashMap<Pair<String, Region>, Secret>();
    private static final Pattern SECRETS_ARN_PATTERN = Pattern.compile("^arn:aws:secretsmanager:(?<region>[^:\\n]*):[^:\\n]*:([^:/\\n]*[:/])?(.*)$");
    final Pair<String, Region> secretKey;
    private final BiFunction<HostSpec, Region, SecretsManagerClient> secretsManagerClientFunc;
    private final Function<String, GetSecretValueRequest> getSecretValueRequestFunc;
    private Secret secret;
    protected PluginService pluginService;
    private final TelemetryCounter fetchCredentialsCounter;

    public AwsSecretsManagerConnectionPlugin(PluginService pluginService, Properties props) {
        this(pluginService, props, (hostSpec, region) -> {
            String endpoint = ENDPOINT_PROPERTY.getString(props);
            if (endpoint != null && !endpoint.isEmpty()) {
                try {
                    URI endpointURI = new URI(endpoint);
                    return (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().credentialsProvider(AwsCredentialsManager.getProvider(hostSpec, props))).endpointOverride(endpointURI)).region(region)).build();
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(Messages.get("AwsSecretsManagerConnectionPlugin.endpointOverrideMisconfigured", new Object[]{e.getMessage()}));
                }
            }
            return (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().credentialsProvider(AwsCredentialsManager.getProvider(hostSpec, props))).region(region)).build();
        }, secretId -> (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretId).build());
    }

    AwsSecretsManagerConnectionPlugin(PluginService pluginService, Properties props, BiFunction<HostSpec, Region, SecretsManagerClient> secretsManagerClientFunc, Function<String, GetSecretValueRequest> getSecretValueRequestFunc) {
        Matcher matcher;
        this.pluginService = pluginService;
        try {
            Class.forName("software.amazon.awssdk.services.secretsmanager.SecretsManagerClient");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(Messages.get("AwsSecretsManagerConnectionPlugin.javaSdkNotInClasspath"));
        }
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(Messages.get("AwsSecretsManagerConnectionPlugin.jacksonDatabindNotInClasspath"));
        }
        String secretId = SECRET_ID_PROPERTY.getString(props);
        if (StringUtils.isNullOrEmpty(secretId)) {
            throw new RuntimeException(Messages.get("AwsSecretsManagerConnectionPlugin.missingRequiredConfigParameter", new Object[]{AwsSecretsManagerConnectionPlugin.SECRET_ID_PROPERTY.name}));
        }
        Region region = regionUtils.getRegion(props, AwsSecretsManagerConnectionPlugin.REGION_PROPERTY.name);
        if (region == null && (matcher = SECRETS_ARN_PATTERN.matcher(secretId)).matches()) {
            region = regionUtils.getRegionFromRegionString(matcher.group("region"));
        }
        if (region == null) {
            throw new RuntimeException(Messages.get("AwsSecretsManagerConnectionPlugin.missingRequiredConfigParameter", new Object[]{AwsSecretsManagerConnectionPlugin.REGION_PROPERTY.name}));
        }
        this.secretKey = Pair.of((Object)secretId, (Object)region);
        this.secretsManagerClientFunc = secretsManagerClientFunc;
        this.getSecretValueRequestFunc = getSecretValueRequestFunc;
        this.fetchCredentialsCounter = this.pluginService.getTelemetryFactory().createCounter(TELEMETRY_FETCH_CREDENTIALS_COUNTER);
    }

    @Override
    public Set<String> getSubscribedMethods() {
        return subscribedMethods;
    }

    @Override
    public Connection connect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        return this.connectInternal(hostSpec, props, connectFunc);
    }

    private Connection connectInternal(HostSpec hostSpec, Properties props, JdbcCallable<Connection, SQLException> connectFunc) throws SQLException {
        boolean secretWasFetched = this.updateSecret(hostSpec, false);
        try {
            this.applySecretToProperties(props);
            return connectFunc.call();
        }
        catch (SQLException exception) {
            if (this.pluginService.isLoginException(exception) && !secretWasFetched && (secretWasFetched = this.updateSecret(hostSpec, true))) {
                this.applySecretToProperties(props);
                return connectFunc.call();
            }
            throw exception;
        }
        catch (Exception exception) {
            LOGGER.warning(() -> Messages.get("AwsSecretsManagerConnectionPlugin.unhandledException", new Object[]{exception}));
            throw new SQLException(exception);
        }
    }

    @Override
    public Connection forceConnect(String driverProtocol, HostSpec hostSpec, Properties props, boolean isInitialConnection, JdbcCallable<Connection, SQLException> forceConnectFunc) throws SQLException {
        return this.connectInternal(hostSpec, props, forceConnectFunc);
    }

    private boolean updateSecret(HostSpec hostSpec, boolean forceReFetch) throws SQLException {
        TelemetryFactory telemetryFactory = this.pluginService.getTelemetryFactory();
        TelemetryContext telemetryContext = telemetryFactory.openTelemetryContext(TELEMETRY_UPDATE_SECRETS, TelemetryTraceLevel.NESTED);
        this.fetchCredentialsCounter.inc();
        try {
            boolean fetched = false;
            this.secret = secretsCache.get(this.secretKey);
            if (this.secret == null || forceReFetch) {
                try {
                    this.secret = this.fetchLatestCredentials(hostSpec);
                    if (this.secret != null) {
                        fetched = true;
                        secretsCache.put(this.secretKey, this.secret);
                    }
                }
                catch (JsonProcessingException | SecretsManagerException exception) {
                    LOGGER.log(Level.WARNING, exception, () -> Messages.get("AwsSecretsManagerConnectionPlugin.failedToFetchDbCredentials"));
                    throw new SQLException(Messages.get("AwsSecretsManagerConnectionPlugin.failedToFetchDbCredentials"), exception);
                }
                catch (SdkClientException exception) {
                    LOGGER.log(Level.WARNING, exception, () -> Messages.get("AwsSecretsManagerConnectionPlugin.endpointOverrideInvalidConnection", new Object[]{exception.getMessage()}));
                    throw new SQLException(Messages.get("AwsSecretsManagerConnectionPlugin.endpointOverrideInvalidConnection", new Object[]{exception.getMessage()}), exception);
                }
                catch (Exception exception) {
                    if (exception.getCause() != null && exception.getCause() instanceof URISyntaxException) {
                        LOGGER.log(Level.WARNING, exception, () -> Messages.get("AwsSecretsManagerConnectionPlugin.endpointOverrideMisconfigured", new Object[]{exception.getCause().getMessage()}));
                        throw new RuntimeException(Messages.get("AwsSecretsManagerConnectionPlugin.endpointOverrideMisconfigured", new Object[]{exception.getCause().getMessage()}));
                    }
                    LOGGER.log(Level.WARNING, exception, () -> Messages.get("AwsSecretsManagerConnectionPlugin.unhandledException", new Object[]{exception.getMessage()}));
                    throw new SQLException(exception);
                }
            }
            boolean bl = fetched;
            return bl;
        }
        catch (Exception ex) {
            telemetryContext.setSuccess(false);
            telemetryContext.setException(ex);
            throw ex;
        }
        finally {
            telemetryContext.closeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Secret fetchLatestCredentials(HostSpec hostSpec) throws SecretsManagerException, JsonProcessingException {
        GetSecretValueResponse valueResponse;
        GetSecretValueRequest request = this.getSecretValueRequestFunc.apply((String)this.secretKey.left());
        try (SecretsManagerClient client = this.secretsManagerClientFunc.apply(hostSpec, (Region)this.secretKey.right());){
            valueResponse = client.getSecretValue(request);
        }
        ObjectMapper mapper = new ObjectMapper();
        return (Secret)mapper.readValue(valueResponse.secretString(), Secret.class);
    }

    private void applySecretToProperties(Properties properties) {
        if (this.secret != null) {
            PropertyDefinition.USER.set(properties, this.secret.getUsername());
            PropertyDefinition.PASSWORD.set(properties, this.secret.getPassword());
        }
    }

    static {
        PropertyDefinition.registerPluginProperties(AwsSecretsManagerConnectionPlugin.class);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Secret {
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="password")
        private String password;

        Secret() {
        }

        Secret(String username, String password) {
            this.username = username;
            this.password = password;
        }

        String getUsername() {
            return this.username;
        }

        String getPassword() {
            return this.password;
        }
    }
}

