/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspaces.model.LoginMessageCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IosImportClientBrandingAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IosImportClientBrandingAttributes> {
    private static final SdkField<SdkBytes> LOGO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Logo").getter(IosImportClientBrandingAttributes.getter(IosImportClientBrandingAttributes::logo)).setter(IosImportClientBrandingAttributes.setter(Builder::logo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logo").build()}).build();
    private static final SdkField<SdkBytes> LOGO2_X_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Logo2x").getter(IosImportClientBrandingAttributes.getter(IosImportClientBrandingAttributes::logo2x)).setter(IosImportClientBrandingAttributes.setter(Builder::logo2x)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logo2x").build()}).build();
    private static final SdkField<SdkBytes> LOGO3_X_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Logo3x").getter(IosImportClientBrandingAttributes.getter(IosImportClientBrandingAttributes::logo3x)).setter(IosImportClientBrandingAttributes.setter(Builder::logo3x)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logo3x").build()}).build();
    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportEmail").getter(IosImportClientBrandingAttributes.getter(IosImportClientBrandingAttributes::supportEmail)).setter(IosImportClientBrandingAttributes.setter(Builder::supportEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()}).build();
    private static final SdkField<String> SUPPORT_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SupportLink").getter(IosImportClientBrandingAttributes.getter(IosImportClientBrandingAttributes::supportLink)).setter(IosImportClientBrandingAttributes.setter(Builder::supportLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportLink").build()}).build();
    private static final SdkField<String> FORGOT_PASSWORD_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForgotPasswordLink").getter(IosImportClientBrandingAttributes.getter(IosImportClientBrandingAttributes::forgotPasswordLink)).setter(IosImportClientBrandingAttributes.setter(Builder::forgotPasswordLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForgotPasswordLink").build()}).build();
    private static final SdkField<Map<String, String>> LOGIN_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("LoginMessage").getter(IosImportClientBrandingAttributes.getter(IosImportClientBrandingAttributes::loginMessage)).setter(IosImportClientBrandingAttributes.setter(Builder::loginMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginMessage").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGO_FIELD, LOGO2_X_FIELD, LOGO3_X_FIELD, SUPPORT_EMAIL_FIELD, SUPPORT_LINK_FIELD, FORGOT_PASSWORD_LINK_FIELD, LOGIN_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Logo", LOGO_FIELD);
            this.put("Logo2x", LOGO2_X_FIELD);
            this.put("Logo3x", LOGO3_X_FIELD);
            this.put("SupportEmail", SUPPORT_EMAIL_FIELD);
            this.put("SupportLink", SUPPORT_LINK_FIELD);
            this.put("ForgotPasswordLink", FORGOT_PASSWORD_LINK_FIELD);
            this.put("LoginMessage", LOGIN_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SdkBytes logo;
    private final SdkBytes logo2x;
    private final SdkBytes logo3x;
    private final String supportEmail;
    private final String supportLink;
    private final String forgotPasswordLink;
    private final Map<String, String> loginMessage;

    private IosImportClientBrandingAttributes(BuilderImpl builder) {
        this.logo = builder.logo;
        this.logo2x = builder.logo2x;
        this.logo3x = builder.logo3x;
        this.supportEmail = builder.supportEmail;
        this.supportLink = builder.supportLink;
        this.forgotPasswordLink = builder.forgotPasswordLink;
        this.loginMessage = builder.loginMessage;
    }

    public final SdkBytes logo() {
        return this.logo;
    }

    public final SdkBytes logo2x() {
        return this.logo2x;
    }

    public final SdkBytes logo3x() {
        return this.logo3x;
    }

    public final String supportEmail() {
        return this.supportEmail;
    }

    public final String supportLink() {
        return this.supportLink;
    }

    public final String forgotPasswordLink() {
        return this.forgotPasswordLink;
    }

    public final boolean hasLoginMessage() {
        return this.loginMessage != null && !(this.loginMessage instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> loginMessage() {
        return this.loginMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logo());
        hashCode = 31 * hashCode + Objects.hashCode(this.logo2x());
        hashCode = 31 * hashCode + Objects.hashCode(this.logo3x());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.forgotPasswordLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoginMessage() ? this.loginMessage() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IosImportClientBrandingAttributes)) {
            return false;
        }
        IosImportClientBrandingAttributes other = (IosImportClientBrandingAttributes)obj;
        return Objects.equals(this.logo(), other.logo()) && Objects.equals(this.logo2x(), other.logo2x()) && Objects.equals(this.logo3x(), other.logo3x()) && Objects.equals(this.supportEmail(), other.supportEmail()) && Objects.equals(this.supportLink(), other.supportLink()) && Objects.equals(this.forgotPasswordLink(), other.forgotPasswordLink()) && this.hasLoginMessage() == other.hasLoginMessage() && Objects.equals(this.loginMessage(), other.loginMessage());
    }

    public final String toString() {
        return ToString.builder((String)"IosImportClientBrandingAttributes").add("Logo", (Object)this.logo()).add("Logo2x", (Object)this.logo2x()).add("Logo3x", (Object)this.logo3x()).add("SupportEmail", (Object)this.supportEmail()).add("SupportLink", (Object)this.supportLink()).add("ForgotPasswordLink", (Object)this.forgotPasswordLink()).add("LoginMessage", this.hasLoginMessage() ? this.loginMessage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Logo": {
                return Optional.ofNullable(clazz.cast(this.logo()));
            }
            case "Logo2x": {
                return Optional.ofNullable(clazz.cast(this.logo2x()));
            }
            case "Logo3x": {
                return Optional.ofNullable(clazz.cast(this.logo3x()));
            }
            case "SupportEmail": {
                return Optional.ofNullable(clazz.cast(this.supportEmail()));
            }
            case "SupportLink": {
                return Optional.ofNullable(clazz.cast(this.supportLink()));
            }
            case "ForgotPasswordLink": {
                return Optional.ofNullable(clazz.cast(this.forgotPasswordLink()));
            }
            case "LoginMessage": {
                return Optional.ofNullable(clazz.cast(this.loginMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IosImportClientBrandingAttributes, T> g) {
        return obj -> g.apply((IosImportClientBrandingAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes logo;
        private SdkBytes logo2x;
        private SdkBytes logo3x;
        private String supportEmail;
        private String supportLink;
        private String forgotPasswordLink;
        private Map<String, String> loginMessage = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IosImportClientBrandingAttributes model) {
            this.logo(model.logo);
            this.logo2x(model.logo2x);
            this.logo3x(model.logo3x);
            this.supportEmail(model.supportEmail);
            this.supportLink(model.supportLink);
            this.forgotPasswordLink(model.forgotPasswordLink);
            this.loginMessage(model.loginMessage);
        }

        public final ByteBuffer getLogo() {
            return this.logo == null ? null : this.logo.asByteBuffer();
        }

        public final void setLogo(ByteBuffer logo) {
            this.logo(logo == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)logo));
        }

        @Override
        public final Builder logo(SdkBytes logo) {
            this.logo = logo;
            return this;
        }

        public final ByteBuffer getLogo2x() {
            return this.logo2x == null ? null : this.logo2x.asByteBuffer();
        }

        public final void setLogo2x(ByteBuffer logo2x) {
            this.logo2x(logo2x == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)logo2x));
        }

        @Override
        public final Builder logo2x(SdkBytes logo2x) {
            this.logo2x = logo2x;
            return this;
        }

        public final ByteBuffer getLogo3x() {
            return this.logo3x == null ? null : this.logo3x.asByteBuffer();
        }

        public final void setLogo3x(ByteBuffer logo3x) {
            this.logo3x(logo3x == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)logo3x));
        }

        @Override
        public final Builder logo3x(SdkBytes logo3x) {
            this.logo3x = logo3x;
            return this;
        }

        public final String getSupportEmail() {
            return this.supportEmail;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final String getSupportLink() {
            return this.supportLink;
        }

        public final void setSupportLink(String supportLink) {
            this.supportLink = supportLink;
        }

        @Override
        public final Builder supportLink(String supportLink) {
            this.supportLink = supportLink;
            return this;
        }

        public final String getForgotPasswordLink() {
            return this.forgotPasswordLink;
        }

        public final void setForgotPasswordLink(String forgotPasswordLink) {
            this.forgotPasswordLink = forgotPasswordLink;
        }

        @Override
        public final Builder forgotPasswordLink(String forgotPasswordLink) {
            this.forgotPasswordLink = forgotPasswordLink;
            return this;
        }

        public final Map<String, String> getLoginMessage() {
            if (this.loginMessage instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.loginMessage;
        }

        public final void setLoginMessage(Map<String, String> loginMessage) {
            this.loginMessage = LoginMessageCopier.copy(loginMessage);
        }

        @Override
        public final Builder loginMessage(Map<String, String> loginMessage) {
            this.loginMessage = LoginMessageCopier.copy(loginMessage);
            return this;
        }

        public IosImportClientBrandingAttributes build() {
            return new IosImportClientBrandingAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IosImportClientBrandingAttributes> {
        public Builder logo(SdkBytes var1);

        public Builder logo2x(SdkBytes var1);

        public Builder logo3x(SdkBytes var1);

        public Builder supportEmail(String var1);

        public Builder supportLink(String var1);

        public Builder forgotPasswordLink(String var1);

        public Builder loginMessage(Map<String, String> var1);
    }
}

