/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.OperatingSystem;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesResponse;
import software.amazon.awssdk.services.workspaces.model.WorkspaceImageRequiredTenancy;
import software.amazon.awssdk.services.workspaces.model.WorkspaceImageState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkspaceImageResponse
extends WorkSpacesResponse
implements ToCopyableBuilder<Builder, CreateWorkspaceImageResponse> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(CreateWorkspaceImageResponse.getter(CreateWorkspaceImageResponse::imageId)).setter(CreateWorkspaceImageResponse.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateWorkspaceImageResponse.getter(CreateWorkspaceImageResponse::name)).setter(CreateWorkspaceImageResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateWorkspaceImageResponse.getter(CreateWorkspaceImageResponse::description)).setter(CreateWorkspaceImageResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<OperatingSystem> OPERATING_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OperatingSystem").getter(CreateWorkspaceImageResponse.getter(CreateWorkspaceImageResponse::operatingSystem)).setter(CreateWorkspaceImageResponse.setter(Builder::operatingSystem)).constructor(OperatingSystem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateWorkspaceImageResponse.getter(CreateWorkspaceImageResponse::stateAsString)).setter(CreateWorkspaceImageResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> REQUIRED_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequiredTenancy").getter(CreateWorkspaceImageResponse.getter(CreateWorkspaceImageResponse::requiredTenancyAsString)).setter(CreateWorkspaceImageResponse.setter(Builder::requiredTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredTenancy").build()}).build();
    private static final SdkField<Instant> CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Created").getter(CreateWorkspaceImageResponse.getter(CreateWorkspaceImageResponse::created)).setter(CreateWorkspaceImageResponse.setter(Builder::created)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerAccountId").getter(CreateWorkspaceImageResponse.getter(CreateWorkspaceImageResponse::ownerAccountId)).setter(CreateWorkspaceImageResponse.setter(Builder::ownerAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, OPERATING_SYSTEM_FIELD, STATE_FIELD, REQUIRED_TENANCY_FIELD, CREATED_FIELD, OWNER_ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ImageId", IMAGE_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("OperatingSystem", OPERATING_SYSTEM_FIELD);
            this.put("State", STATE_FIELD);
            this.put("RequiredTenancy", REQUIRED_TENANCY_FIELD);
            this.put("Created", CREATED_FIELD);
            this.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        }
    });
    private final String imageId;
    private final String name;
    private final String description;
    private final OperatingSystem operatingSystem;
    private final String state;
    private final String requiredTenancy;
    private final Instant created;
    private final String ownerAccountId;

    private CreateWorkspaceImageResponse(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.name = builder.name;
        this.description = builder.description;
        this.operatingSystem = builder.operatingSystem;
        this.state = builder.state;
        this.requiredTenancy = builder.requiredTenancy;
        this.created = builder.created;
        this.ownerAccountId = builder.ownerAccountId;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final OperatingSystem operatingSystem() {
        return this.operatingSystem;
    }

    public final WorkspaceImageState state() {
        return WorkspaceImageState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final WorkspaceImageRequiredTenancy requiredTenancy() {
        return WorkspaceImageRequiredTenancy.fromValue(this.requiredTenancy);
    }

    public final String requiredTenancyAsString() {
        return this.requiredTenancy;
    }

    public final Instant created() {
        return this.created;
    }

    public final String ownerAccountId() {
        return this.ownerAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatingSystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiredTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspaceImageResponse)) {
            return false;
        }
        CreateWorkspaceImageResponse other = (CreateWorkspaceImageResponse)((Object)obj);
        return Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.operatingSystem(), other.operatingSystem()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.requiredTenancyAsString(), other.requiredTenancyAsString()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.ownerAccountId(), other.ownerAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkspaceImageResponse").add("ImageId", (Object)this.imageId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("OperatingSystem", (Object)this.operatingSystem()).add("State", (Object)this.stateAsString()).add("RequiredTenancy", (Object)this.requiredTenancyAsString()).add("Created", (Object)this.created()).add("OwnerAccountId", (Object)this.ownerAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "OperatingSystem": {
                return Optional.ofNullable(clazz.cast(this.operatingSystem()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "RequiredTenancy": {
                return Optional.ofNullable(clazz.cast(this.requiredTenancyAsString()));
            }
            case "Created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "OwnerAccountId": {
                return Optional.ofNullable(clazz.cast(this.ownerAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkspaceImageResponse, T> g) {
        return obj -> g.apply((CreateWorkspaceImageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesResponse.BuilderImpl
    implements Builder {
        private String imageId;
        private String name;
        private String description;
        private OperatingSystem operatingSystem;
        private String state;
        private String requiredTenancy;
        private Instant created;
        private String ownerAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkspaceImageResponse model) {
            super(model);
            this.imageId(model.imageId);
            this.name(model.name);
            this.description(model.description);
            this.operatingSystem(model.operatingSystem);
            this.state(model.state);
            this.requiredTenancy(model.requiredTenancy);
            this.created(model.created);
            this.ownerAccountId(model.ownerAccountId);
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final OperatingSystem.Builder getOperatingSystem() {
            return this.operatingSystem != null ? this.operatingSystem.toBuilder() : null;
        }

        public final void setOperatingSystem(OperatingSystem.BuilderImpl operatingSystem) {
            this.operatingSystem = operatingSystem != null ? operatingSystem.build() : null;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceImageState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getRequiredTenancy() {
            return this.requiredTenancy;
        }

        public final void setRequiredTenancy(String requiredTenancy) {
            this.requiredTenancy = requiredTenancy;
        }

        @Override
        public final Builder requiredTenancy(String requiredTenancy) {
            this.requiredTenancy = requiredTenancy;
            return this;
        }

        @Override
        public final Builder requiredTenancy(WorkspaceImageRequiredTenancy requiredTenancy) {
            this.requiredTenancy(requiredTenancy == null ? null : requiredTenancy.toString());
            return this;
        }

        public final Instant getCreated() {
            return this.created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final String getOwnerAccountId() {
            return this.ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        @Override
        public CreateWorkspaceImageResponse build() {
            return new CreateWorkspaceImageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkspaceImageResponse> {
        public Builder imageId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder operatingSystem(OperatingSystem var1);

        default public Builder operatingSystem(Consumer<OperatingSystem.Builder> operatingSystem) {
            return this.operatingSystem((OperatingSystem)((OperatingSystem.Builder)OperatingSystem.builder().applyMutation(operatingSystem)).build());
        }

        public Builder state(String var1);

        public Builder state(WorkspaceImageState var1);

        public Builder requiredTenancy(String var1);

        public Builder requiredTenancy(WorkspaceImageRequiredTenancy var1);

        public Builder created(Instant var1);

        public Builder ownerAccountId(String var1);
    }
}

