/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.DnsRecord;
import software.amazon.awssdk.services.workmail.model.DnsRecordVerificationStatus;
import software.amazon.awssdk.services.workmail.model.DnsRecordsCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMailDomainResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, GetMailDomainResponse> {
    private static final SdkField<List<DnsRecord>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Records").getter(GetMailDomainResponse.getter(GetMailDomainResponse::records)).setter(GetMailDomainResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DnsRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TEST_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTestDomain").getter(GetMailDomainResponse.getter(GetMailDomainResponse::isTestDomain)).setter(GetMailDomainResponse.setter(Builder::isTestDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTestDomain").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(GetMailDomainResponse.getter(GetMailDomainResponse::isDefault)).setter(GetMailDomainResponse.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final SdkField<String> OWNERSHIP_VERIFICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnershipVerificationStatus").getter(GetMailDomainResponse.getter(GetMailDomainResponse::ownershipVerificationStatusAsString)).setter(GetMailDomainResponse.setter(Builder::ownershipVerificationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnershipVerificationStatus").build()}).build();
    private static final SdkField<String> DKIM_VERIFICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DkimVerificationStatus").getter(GetMailDomainResponse.getter(GetMailDomainResponse::dkimVerificationStatusAsString)).setter(GetMailDomainResponse.setter(Builder::dkimVerificationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DkimVerificationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, IS_TEST_DOMAIN_FIELD, IS_DEFAULT_FIELD, OWNERSHIP_VERIFICATION_STATUS_FIELD, DKIM_VERIFICATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Records", RECORDS_FIELD);
            this.put("IsTestDomain", IS_TEST_DOMAIN_FIELD);
            this.put("IsDefault", IS_DEFAULT_FIELD);
            this.put("OwnershipVerificationStatus", OWNERSHIP_VERIFICATION_STATUS_FIELD);
            this.put("DkimVerificationStatus", DKIM_VERIFICATION_STATUS_FIELD);
        }
    });
    private final List<DnsRecord> records;
    private final Boolean isTestDomain;
    private final Boolean isDefault;
    private final String ownershipVerificationStatus;
    private final String dkimVerificationStatus;

    private GetMailDomainResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.isTestDomain = builder.isTestDomain;
        this.isDefault = builder.isDefault;
        this.ownershipVerificationStatus = builder.ownershipVerificationStatus;
        this.dkimVerificationStatus = builder.dkimVerificationStatus;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<DnsRecord> records() {
        return this.records;
    }

    public final Boolean isTestDomain() {
        return this.isTestDomain;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public final DnsRecordVerificationStatus ownershipVerificationStatus() {
        return DnsRecordVerificationStatus.fromValue(this.ownershipVerificationStatus);
    }

    public final String ownershipVerificationStatusAsString() {
        return this.ownershipVerificationStatus;
    }

    public final DnsRecordVerificationStatus dkimVerificationStatus() {
        return DnsRecordVerificationStatus.fromValue(this.dkimVerificationStatus);
    }

    public final String dkimVerificationStatusAsString() {
        return this.dkimVerificationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTestDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownershipVerificationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dkimVerificationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMailDomainResponse)) {
            return false;
        }
        GetMailDomainResponse other = (GetMailDomainResponse)((Object)obj);
        return this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.isTestDomain(), other.isTestDomain()) && Objects.equals(this.isDefault(), other.isDefault()) && Objects.equals(this.ownershipVerificationStatusAsString(), other.ownershipVerificationStatusAsString()) && Objects.equals(this.dkimVerificationStatusAsString(), other.dkimVerificationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetMailDomainResponse").add("Records", this.hasRecords() ? this.records() : null).add("IsTestDomain", (Object)this.isTestDomain()).add("IsDefault", (Object)this.isDefault()).add("OwnershipVerificationStatus", (Object)this.ownershipVerificationStatusAsString()).add("DkimVerificationStatus", (Object)this.dkimVerificationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "IsTestDomain": {
                return Optional.ofNullable(clazz.cast(this.isTestDomain()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
            case "OwnershipVerificationStatus": {
                return Optional.ofNullable(clazz.cast(this.ownershipVerificationStatusAsString()));
            }
            case "DkimVerificationStatus": {
                return Optional.ofNullable(clazz.cast(this.dkimVerificationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMailDomainResponse, T> g) {
        return obj -> g.apply((GetMailDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private List<DnsRecord> records = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTestDomain;
        private Boolean isDefault;
        private String ownershipVerificationStatus;
        private String dkimVerificationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMailDomainResponse model) {
            super(model);
            this.records(model.records);
            this.isTestDomain(model.isTestDomain);
            this.isDefault(model.isDefault);
            this.ownershipVerificationStatus(model.ownershipVerificationStatus);
            this.dkimVerificationStatus(model.dkimVerificationStatus);
        }

        public final List<DnsRecord.Builder> getRecords() {
            List<DnsRecord.Builder> result = DnsRecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<DnsRecord.BuilderImpl> records) {
            this.records = DnsRecordsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<DnsRecord> records) {
            this.records = DnsRecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(DnsRecord ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<DnsRecord.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (DnsRecord)((DnsRecord.Builder)DnsRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTestDomain() {
            return this.isTestDomain;
        }

        public final void setIsTestDomain(Boolean isTestDomain) {
            this.isTestDomain = isTestDomain;
        }

        @Override
        public final Builder isTestDomain(Boolean isTestDomain) {
            this.isTestDomain = isTestDomain;
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getOwnershipVerificationStatus() {
            return this.ownershipVerificationStatus;
        }

        public final void setOwnershipVerificationStatus(String ownershipVerificationStatus) {
            this.ownershipVerificationStatus = ownershipVerificationStatus;
        }

        @Override
        public final Builder ownershipVerificationStatus(String ownershipVerificationStatus) {
            this.ownershipVerificationStatus = ownershipVerificationStatus;
            return this;
        }

        @Override
        public final Builder ownershipVerificationStatus(DnsRecordVerificationStatus ownershipVerificationStatus) {
            this.ownershipVerificationStatus(ownershipVerificationStatus == null ? null : ownershipVerificationStatus.toString());
            return this;
        }

        public final String getDkimVerificationStatus() {
            return this.dkimVerificationStatus;
        }

        public final void setDkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
        }

        @Override
        public final Builder dkimVerificationStatus(String dkimVerificationStatus) {
            this.dkimVerificationStatus = dkimVerificationStatus;
            return this;
        }

        @Override
        public final Builder dkimVerificationStatus(DnsRecordVerificationStatus dkimVerificationStatus) {
            this.dkimVerificationStatus(dkimVerificationStatus == null ? null : dkimVerificationStatus.toString());
            return this;
        }

        @Override
        public GetMailDomainResponse build() {
            return new GetMailDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMailDomainResponse> {
        public Builder records(Collection<DnsRecord> var1);

        public Builder records(DnsRecord ... var1);

        public Builder records(Consumer<DnsRecord.Builder> ... var1);

        public Builder isTestDomain(Boolean var1);

        public Builder isDefault(Boolean var1);

        public Builder ownershipVerificationStatus(String var1);

        public Builder ownershipVerificationStatus(DnsRecordVerificationStatus var1);

        public Builder dkimVerificationStatus(String var1);

        public Builder dkimVerificationStatus(DnsRecordVerificationStatus var1);
    }
}

