/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.SelectedQuestionIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelectedPillar
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelectedPillar> {
    private static final SdkField<String> PILLAR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PillarId").getter(SelectedPillar.getter(SelectedPillar::pillarId)).setter(SelectedPillar.setter(Builder::pillarId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PillarId").build()}).build();
    private static final SdkField<List<String>> SELECTED_QUESTION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedQuestionIds").getter(SelectedPillar.getter(SelectedPillar::selectedQuestionIds)).setter(SelectedPillar.setter(Builder::selectedQuestionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedQuestionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PILLAR_ID_FIELD, SELECTED_QUESTION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PillarId", PILLAR_ID_FIELD);
            this.put("SelectedQuestionIds", SELECTED_QUESTION_IDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String pillarId;
    private final List<String> selectedQuestionIds;

    private SelectedPillar(BuilderImpl builder) {
        this.pillarId = builder.pillarId;
        this.selectedQuestionIds = builder.selectedQuestionIds;
    }

    public final String pillarId() {
        return this.pillarId;
    }

    public final boolean hasSelectedQuestionIds() {
        return this.selectedQuestionIds != null && !(this.selectedQuestionIds instanceof SdkAutoConstructList);
    }

    public final List<String> selectedQuestionIds() {
        return this.selectedQuestionIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pillarId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedQuestionIds() ? this.selectedQuestionIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectedPillar)) {
            return false;
        }
        SelectedPillar other = (SelectedPillar)obj;
        return Objects.equals(this.pillarId(), other.pillarId()) && this.hasSelectedQuestionIds() == other.hasSelectedQuestionIds() && Objects.equals(this.selectedQuestionIds(), other.selectedQuestionIds());
    }

    public final String toString() {
        return ToString.builder((String)"SelectedPillar").add("PillarId", (Object)this.pillarId()).add("SelectedQuestionIds", this.hasSelectedQuestionIds() ? this.selectedQuestionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PillarId": {
                return Optional.ofNullable(clazz.cast(this.pillarId()));
            }
            case "SelectedQuestionIds": {
                return Optional.ofNullable(clazz.cast(this.selectedQuestionIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SelectedPillar, T> g) {
        return obj -> g.apply((SelectedPillar)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pillarId;
        private List<String> selectedQuestionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SelectedPillar model) {
            this.pillarId(model.pillarId);
            this.selectedQuestionIds(model.selectedQuestionIds);
        }

        public final String getPillarId() {
            return this.pillarId;
        }

        public final void setPillarId(String pillarId) {
            this.pillarId = pillarId;
        }

        @Override
        public final Builder pillarId(String pillarId) {
            this.pillarId = pillarId;
            return this;
        }

        public final Collection<String> getSelectedQuestionIds() {
            if (this.selectedQuestionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedQuestionIds;
        }

        public final void setSelectedQuestionIds(Collection<String> selectedQuestionIds) {
            this.selectedQuestionIds = SelectedQuestionIdsCopier.copy(selectedQuestionIds);
        }

        @Override
        public final Builder selectedQuestionIds(Collection<String> selectedQuestionIds) {
            this.selectedQuestionIds = SelectedQuestionIdsCopier.copy(selectedQuestionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedQuestionIds(String ... selectedQuestionIds) {
            this.selectedQuestionIds(Arrays.asList(selectedQuestionIds));
            return this;
        }

        public SelectedPillar build() {
            return new SelectedPillar(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelectedPillar> {
        public Builder pillarId(String var1);

        public Builder selectedQuestionIds(Collection<String> var1);

        public Builder selectedQuestionIds(String ... var1);
    }
}

