/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.wellarchitected.model.PermissionType;
import software.amazon.awssdk.services.wellarchitected.model.WellArchitectedRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorkloadShareRequest
extends WellArchitectedRequest
implements ToCopyableBuilder<Builder, CreateWorkloadShareRequest> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(CreateWorkloadShareRequest.getter(CreateWorkloadShareRequest::workloadId)).setter(CreateWorkloadShareRequest.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> SHARED_WITH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SharedWith").getter(CreateWorkloadShareRequest.getter(CreateWorkloadShareRequest::sharedWith)).setter(CreateWorkloadShareRequest.setter(Builder::sharedWith)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedWith").build()}).build();
    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionType").getter(CreateWorkloadShareRequest.getter(CreateWorkloadShareRequest::permissionTypeAsString)).setter(CreateWorkloadShareRequest.setter(Builder::permissionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionType").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateWorkloadShareRequest.getter(CreateWorkloadShareRequest::clientRequestToken)).setter(CreateWorkloadShareRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, SHARED_WITH_FIELD, PERMISSION_TYPE_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WorkloadId", WORKLOAD_ID_FIELD);
            this.put("SharedWith", SHARED_WITH_FIELD);
            this.put("PermissionType", PERMISSION_TYPE_FIELD);
            this.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        }
    });
    private final String workloadId;
    private final String sharedWith;
    private final String permissionType;
    private final String clientRequestToken;

    private CreateWorkloadShareRequest(BuilderImpl builder) {
        super(builder);
        this.workloadId = builder.workloadId;
        this.sharedWith = builder.sharedWith;
        this.permissionType = builder.permissionType;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String sharedWith() {
        return this.sharedWith;
    }

    public final PermissionType permissionType() {
        return PermissionType.fromValue(this.permissionType);
    }

    public final String permissionTypeAsString() {
        return this.permissionType;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharedWith());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkloadShareRequest)) {
            return false;
        }
        CreateWorkloadShareRequest other = (CreateWorkloadShareRequest)((Object)obj);
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.sharedWith(), other.sharedWith()) && Objects.equals(this.permissionTypeAsString(), other.permissionTypeAsString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorkloadShareRequest").add("WorkloadId", (Object)this.workloadId()).add("SharedWith", (Object)this.sharedWith()).add("PermissionType", (Object)this.permissionTypeAsString()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "SharedWith": {
                return Optional.ofNullable(clazz.cast(this.sharedWith()));
            }
            case "PermissionType": {
                return Optional.ofNullable(clazz.cast(this.permissionTypeAsString()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkloadShareRequest, T> g) {
        return obj -> g.apply((CreateWorkloadShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WellArchitectedRequest.BuilderImpl
    implements Builder {
        private String workloadId;
        private String sharedWith;
        private String permissionType;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkloadShareRequest model) {
            super(model);
            this.workloadId(model.workloadId);
            this.sharedWith(model.sharedWith);
            this.permissionType(model.permissionType);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getSharedWith() {
            return this.sharedWith;
        }

        public final void setSharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
        }

        @Override
        public final Builder sharedWith(String sharedWith) {
            this.sharedWith = sharedWith;
            return this;
        }

        public final String getPermissionType() {
            return this.permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        public final Builder permissionType(PermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkloadShareRequest build() {
            return new CreateWorkloadShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WellArchitectedRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorkloadShareRequest> {
        public Builder workloadId(String var1);

        public Builder sharedWith(String var1);

        public Builder permissionType(String var1);

        public Builder permissionType(PermissionType var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

