/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.AccessLogSubscriptionSummary;
import software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsResponse;

public class ListAccessLogSubscriptionsIterable
implements SdkIterable<ListAccessLogSubscriptionsResponse> {
    private final VpcLatticeClient client;
    private final ListAccessLogSubscriptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessLogSubscriptionsIterable(VpcLatticeClient client, ListAccessLogSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessLogSubscriptionsResponseFetcher();
    }

    public Iterator<ListAccessLogSubscriptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessLogSubscriptionSummary> items() {
        Function<ListAccessLogSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessLogSubscriptionsResponseFetcher
    implements SyncPageFetcher<ListAccessLogSubscriptionsResponse> {
        private ListAccessLogSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessLogSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessLogSubscriptionsResponse nextPage(ListAccessLogSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessLogSubscriptionsIterable.this.client.listAccessLogSubscriptions(ListAccessLogSubscriptionsIterable.this.firstRequest);
            }
            return ListAccessLogSubscriptionsIterable.this.client.listAccessLogSubscriptions((ListAccessLogSubscriptionsRequest)((Object)ListAccessLogSubscriptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

