/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPolicyTemplateResponse
extends VerifiedPermissionsResponse
implements ToCopyableBuilder<Builder, GetPolicyTemplateResponse> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(GetPolicyTemplateResponse.getter(GetPolicyTemplateResponse::policyStoreId)).setter(GetPolicyTemplateResponse.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<String> POLICY_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyTemplateId").getter(GetPolicyTemplateResponse.getter(GetPolicyTemplateResponse::policyTemplateId)).setter(GetPolicyTemplateResponse.setter(Builder::policyTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyTemplateId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetPolicyTemplateResponse.getter(GetPolicyTemplateResponse::description)).setter(GetPolicyTemplateResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> STATEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statement").getter(GetPolicyTemplateResponse.getter(GetPolicyTemplateResponse::statement)).setter(GetPolicyTemplateResponse.setter(Builder::statement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statement").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(GetPolicyTemplateResponse.getter(GetPolicyTemplateResponse::createdDate)).setter(GetPolicyTemplateResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDate").getter(GetPolicyTemplateResponse.getter(GetPolicyTemplateResponse::lastUpdatedDate)).setter(GetPolicyTemplateResponse.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD, POLICY_TEMPLATE_ID_FIELD, DESCRIPTION_FIELD, STATEMENT_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("policyStoreId", POLICY_STORE_ID_FIELD);
            this.put("policyTemplateId", POLICY_TEMPLATE_ID_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("statement", STATEMENT_FIELD);
            this.put("createdDate", CREATED_DATE_FIELD);
            this.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        }
    });
    private final String policyStoreId;
    private final String policyTemplateId;
    private final String description;
    private final String statement;
    private final Instant createdDate;
    private final Instant lastUpdatedDate;

    private GetPolicyTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.policyTemplateId = builder.policyTemplateId;
        this.description = builder.description;
        this.statement = builder.statement;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final String policyTemplateId() {
        return this.policyTemplateId;
    }

    public final String description() {
        return this.description;
    }

    public final String statement() {
        return this.statement;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statement());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyTemplateResponse)) {
            return false;
        }
        GetPolicyTemplateResponse other = (GetPolicyTemplateResponse)((Object)obj);
        return Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.policyTemplateId(), other.policyTemplateId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statement(), other.statement()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate());
    }

    public final String toString() {
        return ToString.builder((String)"GetPolicyTemplateResponse").add("PolicyStoreId", (Object)this.policyStoreId()).add("PolicyTemplateId", (Object)this.policyTemplateId()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Statement", (Object)(this.statement() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "policyTemplateId": {
                return Optional.ofNullable(clazz.cast(this.policyTemplateId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "statement": {
                return Optional.ofNullable(clazz.cast(this.statement()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetPolicyTemplateResponse, T> g) {
        return obj -> g.apply((GetPolicyTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsResponse.BuilderImpl
    implements Builder {
        private String policyStoreId;
        private String policyTemplateId;
        private String description;
        private String statement;
        private Instant createdDate;
        private Instant lastUpdatedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyTemplateResponse model) {
            super(model);
            this.policyStoreId(model.policyStoreId);
            this.policyTemplateId(model.policyTemplateId);
            this.description(model.description);
            this.statement(model.statement);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getPolicyTemplateId() {
            return this.policyTemplateId;
        }

        public final void setPolicyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
        }

        @Override
        public final Builder policyTemplateId(String policyTemplateId) {
            this.policyTemplateId = policyTemplateId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatement() {
            return this.statement;
        }

        public final void setStatement(String statement) {
            this.statement = statement;
        }

        @Override
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        @Override
        public GetPolicyTemplateResponse build() {
            return new GetPolicyTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPolicyTemplateResponse> {
        public Builder policyStoreId(String var1);

        public Builder policyTemplateId(String var1);

        public Builder description(String var1);

        public Builder statement(String var1);

        public Builder createdDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);
    }
}

