/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.verifiedpermissions.model.AttributeValue;
import software.amazon.awssdk.services.verifiedpermissions.model.EntityAttributesCopier;
import software.amazon.awssdk.services.verifiedpermissions.model.EntityIdentifier;
import software.amazon.awssdk.services.verifiedpermissions.model.ParentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntityItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntityItem> {
    private static final SdkField<EntityIdentifier> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("identifier").getter(EntityItem.getter(EntityItem::identifier)).setter(EntityItem.setter(Builder::identifier)).constructor(EntityIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(EntityItem.getter(EntityItem::attributes)).setter(EntityItem.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<EntityIdentifier>> PARENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parents").getter(EntityItem.getter(EntityItem::parents)).setter(EntityItem.setter(Builder::parents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, ATTRIBUTES_FIELD, PARENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("attributes", ATTRIBUTES_FIELD);
            this.put("parents", PARENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final EntityIdentifier identifier;
    private final Map<String, AttributeValue> attributes;
    private final List<EntityIdentifier> parents;

    private EntityItem(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.attributes = builder.attributes;
        this.parents = builder.parents;
    }

    public final EntityIdentifier identifier() {
        return this.identifier;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> attributes() {
        return this.attributes;
    }

    public final boolean hasParents() {
        return this.parents != null && !(this.parents instanceof SdkAutoConstructList);
    }

    public final List<EntityIdentifier> parents() {
        return this.parents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParents() ? this.parents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityItem)) {
            return false;
        }
        EntityItem other = (EntityItem)obj;
        return Objects.equals(this.identifier(), other.identifier()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasParents() == other.hasParents() && Objects.equals(this.parents(), other.parents());
    }

    public final String toString() {
        return ToString.builder((String)"EntityItem").add("Identifier", (Object)this.identifier()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Parents", this.hasParents() ? this.parents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "parents": {
                return Optional.ofNullable(clazz.cast(this.parents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EntityItem, T> g) {
        return obj -> g.apply((EntityItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EntityIdentifier identifier;
        private Map<String, AttributeValue> attributes = DefaultSdkAutoConstructMap.getInstance();
        private List<EntityIdentifier> parents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EntityItem model) {
            this.identifier(model.identifier);
            this.attributes(model.attributes);
            this.parents(model.parents);
        }

        public final EntityIdentifier.Builder getIdentifier() {
            return this.identifier != null ? this.identifier.toBuilder() : null;
        }

        public final void setIdentifier(EntityIdentifier.BuilderImpl identifier) {
            this.identifier = identifier != null ? identifier.build() : null;
        }

        @Override
        public final Builder identifier(EntityIdentifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public final Map<String, AttributeValue.Builder> getAttributes() {
            Map<String, AttributeValue.Builder> result = EntityAttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Map<String, AttributeValue.BuilderImpl> attributes) {
            this.attributes = EntityAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Map<String, AttributeValue> attributes) {
            this.attributes = EntityAttributesCopier.copy(attributes);
            return this;
        }

        public final List<EntityIdentifier.Builder> getParents() {
            List<EntityIdentifier.Builder> result = ParentListCopier.copyToBuilder(this.parents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParents(Collection<EntityIdentifier.BuilderImpl> parents) {
            this.parents = ParentListCopier.copyFromBuilder(parents);
        }

        @Override
        public final Builder parents(Collection<EntityIdentifier> parents) {
            this.parents = ParentListCopier.copy(parents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(EntityIdentifier ... parents) {
            this.parents(Arrays.asList(parents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Consumer<EntityIdentifier.Builder> ... parents) {
            this.parents(Stream.of(parents).map(c -> (EntityIdentifier)((EntityIdentifier.Builder)EntityIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EntityItem build() {
            return new EntityItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntityItem> {
        public Builder identifier(EntityIdentifier var1);

        default public Builder identifier(Consumer<EntityIdentifier.Builder> identifier) {
            return this.identifier((EntityIdentifier)((EntityIdentifier.Builder)EntityIdentifier.builder().applyMutation(identifier)).build());
        }

        public Builder attributes(Map<String, AttributeValue> var1);

        public Builder parents(Collection<EntityIdentifier> var1);

        public Builder parents(EntityIdentifier ... var1);

        public Builder parents(Consumer<EntityIdentifier.Builder> ... var1);
    }
}

