/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.ContentRedaction;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.LanguageCodeItem;
import software.amazon.awssdk.services.transcribe.model.LanguageCodeListCopier;
import software.amazon.awssdk.services.transcribe.model.ModelSettings;
import software.amazon.awssdk.services.transcribe.model.OutputLocationType;
import software.amazon.awssdk.services.transcribe.model.ToxicityDetectionCopier;
import software.amazon.awssdk.services.transcribe.model.ToxicityDetectionSettings;
import software.amazon.awssdk.services.transcribe.model.TranscriptionJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TranscriptionJobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TranscriptionJobSummary> {
    private static final SdkField<String> TRANSCRIPTION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptionJobName").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::transcriptionJobName)).setter(TranscriptionJobSummary.setter(Builder::transcriptionJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::creationTime)).setter(TranscriptionJobSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::startTime)).setter(TranscriptionJobSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionTime").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::completionTime)).setter(TranscriptionJobSummary.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::languageCodeAsString)).setter(TranscriptionJobSummary.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> TRANSCRIPTION_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptionJobStatus").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::transcriptionJobStatusAsString)).setter(TranscriptionJobSummary.setter(Builder::transcriptionJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptionJobStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::failureReason)).setter(TranscriptionJobSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> OUTPUT_LOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputLocationType").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::outputLocationTypeAsString)).setter(TranscriptionJobSummary.setter(Builder::outputLocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocationType").build()}).build();
    private static final SdkField<ContentRedaction> CONTENT_REDACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContentRedaction").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::contentRedaction)).setter(TranscriptionJobSummary.setter(Builder::contentRedaction)).constructor(ContentRedaction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentRedaction").build()}).build();
    private static final SdkField<ModelSettings> MODEL_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelSettings").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::modelSettings)).setter(TranscriptionJobSummary.setter(Builder::modelSettings)).constructor(ModelSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelSettings").build()}).build();
    private static final SdkField<Boolean> IDENTIFY_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IdentifyLanguage").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::identifyLanguage)).setter(TranscriptionJobSummary.setter(Builder::identifyLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifyLanguage").build()}).build();
    private static final SdkField<Boolean> IDENTIFY_MULTIPLE_LANGUAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IdentifyMultipleLanguages").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::identifyMultipleLanguages)).setter(TranscriptionJobSummary.setter(Builder::identifyMultipleLanguages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifyMultipleLanguages").build()}).build();
    private static final SdkField<Float> IDENTIFIED_LANGUAGE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("IdentifiedLanguageScore").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::identifiedLanguageScore)).setter(TranscriptionJobSummary.setter(Builder::identifiedLanguageScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentifiedLanguageScore").build()}).build();
    private static final SdkField<List<LanguageCodeItem>> LANGUAGE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LanguageCodes").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::languageCodes)).setter(TranscriptionJobSummary.setter(Builder::languageCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LanguageCodeItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ToxicityDetectionSettings>> TOXICITY_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ToxicityDetection").getter(TranscriptionJobSummary.getter(TranscriptionJobSummary::toxicityDetection)).setter(TranscriptionJobSummary.setter(Builder::toxicityDetection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToxicityDetection").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ToxicityDetectionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSCRIPTION_JOB_NAME_FIELD, CREATION_TIME_FIELD, START_TIME_FIELD, COMPLETION_TIME_FIELD, LANGUAGE_CODE_FIELD, TRANSCRIPTION_JOB_STATUS_FIELD, FAILURE_REASON_FIELD, OUTPUT_LOCATION_TYPE_FIELD, CONTENT_REDACTION_FIELD, MODEL_SETTINGS_FIELD, IDENTIFY_LANGUAGE_FIELD, IDENTIFY_MULTIPLE_LANGUAGES_FIELD, IDENTIFIED_LANGUAGE_SCORE_FIELD, LANGUAGE_CODES_FIELD, TOXICITY_DETECTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TranscriptionJobName", TRANSCRIPTION_JOB_NAME_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("CompletionTime", COMPLETION_TIME_FIELD);
            this.put("LanguageCode", LANGUAGE_CODE_FIELD);
            this.put("TranscriptionJobStatus", TRANSCRIPTION_JOB_STATUS_FIELD);
            this.put("FailureReason", FAILURE_REASON_FIELD);
            this.put("OutputLocationType", OUTPUT_LOCATION_TYPE_FIELD);
            this.put("ContentRedaction", CONTENT_REDACTION_FIELD);
            this.put("ModelSettings", MODEL_SETTINGS_FIELD);
            this.put("IdentifyLanguage", IDENTIFY_LANGUAGE_FIELD);
            this.put("IdentifyMultipleLanguages", IDENTIFY_MULTIPLE_LANGUAGES_FIELD);
            this.put("IdentifiedLanguageScore", IDENTIFIED_LANGUAGE_SCORE_FIELD);
            this.put("LanguageCodes", LANGUAGE_CODES_FIELD);
            this.put("ToxicityDetection", TOXICITY_DETECTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String transcriptionJobName;
    private final Instant creationTime;
    private final Instant startTime;
    private final Instant completionTime;
    private final String languageCode;
    private final String transcriptionJobStatus;
    private final String failureReason;
    private final String outputLocationType;
    private final ContentRedaction contentRedaction;
    private final ModelSettings modelSettings;
    private final Boolean identifyLanguage;
    private final Boolean identifyMultipleLanguages;
    private final Float identifiedLanguageScore;
    private final List<LanguageCodeItem> languageCodes;
    private final List<ToxicityDetectionSettings> toxicityDetection;

    private TranscriptionJobSummary(BuilderImpl builder) {
        this.transcriptionJobName = builder.transcriptionJobName;
        this.creationTime = builder.creationTime;
        this.startTime = builder.startTime;
        this.completionTime = builder.completionTime;
        this.languageCode = builder.languageCode;
        this.transcriptionJobStatus = builder.transcriptionJobStatus;
        this.failureReason = builder.failureReason;
        this.outputLocationType = builder.outputLocationType;
        this.contentRedaction = builder.contentRedaction;
        this.modelSettings = builder.modelSettings;
        this.identifyLanguage = builder.identifyLanguage;
        this.identifyMultipleLanguages = builder.identifyMultipleLanguages;
        this.identifiedLanguageScore = builder.identifiedLanguageScore;
        this.languageCodes = builder.languageCodes;
        this.toxicityDetection = builder.toxicityDetection;
    }

    public final String transcriptionJobName() {
        return this.transcriptionJobName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final TranscriptionJobStatus transcriptionJobStatus() {
        return TranscriptionJobStatus.fromValue(this.transcriptionJobStatus);
    }

    public final String transcriptionJobStatusAsString() {
        return this.transcriptionJobStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final OutputLocationType outputLocationType() {
        return OutputLocationType.fromValue(this.outputLocationType);
    }

    public final String outputLocationTypeAsString() {
        return this.outputLocationType;
    }

    public final ContentRedaction contentRedaction() {
        return this.contentRedaction;
    }

    public final ModelSettings modelSettings() {
        return this.modelSettings;
    }

    public final Boolean identifyLanguage() {
        return this.identifyLanguage;
    }

    public final Boolean identifyMultipleLanguages() {
        return this.identifyMultipleLanguages;
    }

    public final Float identifiedLanguageScore() {
        return this.identifiedLanguageScore;
    }

    public final boolean hasLanguageCodes() {
        return this.languageCodes != null && !(this.languageCodes instanceof SdkAutoConstructList);
    }

    public final List<LanguageCodeItem> languageCodes() {
        return this.languageCodes;
    }

    public final boolean hasToxicityDetection() {
        return this.toxicityDetection != null && !(this.toxicityDetection instanceof SdkAutoConstructList);
    }

    public final List<ToxicityDetectionSettings> toxicityDetection() {
        return this.toxicityDetection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptionJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptionJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRedaction());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifyLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifyMultipleLanguages());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifiedLanguageScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLanguageCodes() ? this.languageCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasToxicityDetection() ? this.toxicityDetection() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptionJobSummary)) {
            return false;
        }
        TranscriptionJobSummary other = (TranscriptionJobSummary)obj;
        return Objects.equals(this.transcriptionJobName(), other.transcriptionJobName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.transcriptionJobStatusAsString(), other.transcriptionJobStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.outputLocationTypeAsString(), other.outputLocationTypeAsString()) && Objects.equals(this.contentRedaction(), other.contentRedaction()) && Objects.equals(this.modelSettings(), other.modelSettings()) && Objects.equals(this.identifyLanguage(), other.identifyLanguage()) && Objects.equals(this.identifyMultipleLanguages(), other.identifyMultipleLanguages()) && Objects.equals(this.identifiedLanguageScore(), other.identifiedLanguageScore()) && this.hasLanguageCodes() == other.hasLanguageCodes() && Objects.equals(this.languageCodes(), other.languageCodes()) && this.hasToxicityDetection() == other.hasToxicityDetection() && Objects.equals(this.toxicityDetection(), other.toxicityDetection());
    }

    public final String toString() {
        return ToString.builder((String)"TranscriptionJobSummary").add("TranscriptionJobName", (Object)this.transcriptionJobName()).add("CreationTime", (Object)this.creationTime()).add("StartTime", (Object)this.startTime()).add("CompletionTime", (Object)this.completionTime()).add("LanguageCode", (Object)this.languageCodeAsString()).add("TranscriptionJobStatus", (Object)this.transcriptionJobStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("OutputLocationType", (Object)this.outputLocationTypeAsString()).add("ContentRedaction", (Object)this.contentRedaction()).add("ModelSettings", (Object)this.modelSettings()).add("IdentifyLanguage", (Object)this.identifyLanguage()).add("IdentifyMultipleLanguages", (Object)this.identifyMultipleLanguages()).add("IdentifiedLanguageScore", (Object)this.identifiedLanguageScore()).add("LanguageCodes", this.hasLanguageCodes() ? this.languageCodes() : null).add("ToxicityDetection", this.hasToxicityDetection() ? this.toxicityDetection() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TranscriptionJobName": {
                return Optional.ofNullable(clazz.cast(this.transcriptionJobName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "CompletionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "TranscriptionJobStatus": {
                return Optional.ofNullable(clazz.cast(this.transcriptionJobStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "OutputLocationType": {
                return Optional.ofNullable(clazz.cast(this.outputLocationTypeAsString()));
            }
            case "ContentRedaction": {
                return Optional.ofNullable(clazz.cast(this.contentRedaction()));
            }
            case "ModelSettings": {
                return Optional.ofNullable(clazz.cast(this.modelSettings()));
            }
            case "IdentifyLanguage": {
                return Optional.ofNullable(clazz.cast(this.identifyLanguage()));
            }
            case "IdentifyMultipleLanguages": {
                return Optional.ofNullable(clazz.cast(this.identifyMultipleLanguages()));
            }
            case "IdentifiedLanguageScore": {
                return Optional.ofNullable(clazz.cast(this.identifiedLanguageScore()));
            }
            case "LanguageCodes": {
                return Optional.ofNullable(clazz.cast(this.languageCodes()));
            }
            case "ToxicityDetection": {
                return Optional.ofNullable(clazz.cast(this.toxicityDetection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TranscriptionJobSummary, T> g) {
        return obj -> g.apply((TranscriptionJobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transcriptionJobName;
        private Instant creationTime;
        private Instant startTime;
        private Instant completionTime;
        private String languageCode;
        private String transcriptionJobStatus;
        private String failureReason;
        private String outputLocationType;
        private ContentRedaction contentRedaction;
        private ModelSettings modelSettings;
        private Boolean identifyLanguage;
        private Boolean identifyMultipleLanguages;
        private Float identifiedLanguageScore;
        private List<LanguageCodeItem> languageCodes = DefaultSdkAutoConstructList.getInstance();
        private List<ToxicityDetectionSettings> toxicityDetection = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TranscriptionJobSummary model) {
            this.transcriptionJobName(model.transcriptionJobName);
            this.creationTime(model.creationTime);
            this.startTime(model.startTime);
            this.completionTime(model.completionTime);
            this.languageCode(model.languageCode);
            this.transcriptionJobStatus(model.transcriptionJobStatus);
            this.failureReason(model.failureReason);
            this.outputLocationType(model.outputLocationType);
            this.contentRedaction(model.contentRedaction);
            this.modelSettings(model.modelSettings);
            this.identifyLanguage(model.identifyLanguage);
            this.identifyMultipleLanguages(model.identifyMultipleLanguages);
            this.identifiedLanguageScore(model.identifiedLanguageScore);
            this.languageCodes(model.languageCodes);
            this.toxicityDetection(model.toxicityDetection);
        }

        public final String getTranscriptionJobName() {
            return this.transcriptionJobName;
        }

        public final void setTranscriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
        }

        @Override
        public final Builder transcriptionJobName(String transcriptionJobName) {
            this.transcriptionJobName = transcriptionJobName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getTranscriptionJobStatus() {
            return this.transcriptionJobStatus;
        }

        public final void setTranscriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
        }

        @Override
        public final Builder transcriptionJobStatus(String transcriptionJobStatus) {
            this.transcriptionJobStatus = transcriptionJobStatus;
            return this;
        }

        @Override
        public final Builder transcriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus) {
            this.transcriptionJobStatus(transcriptionJobStatus == null ? null : transcriptionJobStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getOutputLocationType() {
            return this.outputLocationType;
        }

        public final void setOutputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
        }

        @Override
        public final Builder outputLocationType(String outputLocationType) {
            this.outputLocationType = outputLocationType;
            return this;
        }

        @Override
        public final Builder outputLocationType(OutputLocationType outputLocationType) {
            this.outputLocationType(outputLocationType == null ? null : outputLocationType.toString());
            return this;
        }

        public final ContentRedaction.Builder getContentRedaction() {
            return this.contentRedaction != null ? this.contentRedaction.toBuilder() : null;
        }

        public final void setContentRedaction(ContentRedaction.BuilderImpl contentRedaction) {
            this.contentRedaction = contentRedaction != null ? contentRedaction.build() : null;
        }

        @Override
        public final Builder contentRedaction(ContentRedaction contentRedaction) {
            this.contentRedaction = contentRedaction;
            return this;
        }

        public final ModelSettings.Builder getModelSettings() {
            return this.modelSettings != null ? this.modelSettings.toBuilder() : null;
        }

        public final void setModelSettings(ModelSettings.BuilderImpl modelSettings) {
            this.modelSettings = modelSettings != null ? modelSettings.build() : null;
        }

        @Override
        public final Builder modelSettings(ModelSettings modelSettings) {
            this.modelSettings = modelSettings;
            return this;
        }

        public final Boolean getIdentifyLanguage() {
            return this.identifyLanguage;
        }

        public final void setIdentifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
        }

        @Override
        public final Builder identifyLanguage(Boolean identifyLanguage) {
            this.identifyLanguage = identifyLanguage;
            return this;
        }

        public final Boolean getIdentifyMultipleLanguages() {
            return this.identifyMultipleLanguages;
        }

        public final void setIdentifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
        }

        @Override
        public final Builder identifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
            return this;
        }

        public final Float getIdentifiedLanguageScore() {
            return this.identifiedLanguageScore;
        }

        public final void setIdentifiedLanguageScore(Float identifiedLanguageScore) {
            this.identifiedLanguageScore = identifiedLanguageScore;
        }

        @Override
        public final Builder identifiedLanguageScore(Float identifiedLanguageScore) {
            this.identifiedLanguageScore = identifiedLanguageScore;
            return this;
        }

        public final List<LanguageCodeItem.Builder> getLanguageCodes() {
            List<LanguageCodeItem.Builder> result = LanguageCodeListCopier.copyToBuilder(this.languageCodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLanguageCodes(Collection<LanguageCodeItem.BuilderImpl> languageCodes) {
            this.languageCodes = LanguageCodeListCopier.copyFromBuilder(languageCodes);
        }

        @Override
        public final Builder languageCodes(Collection<LanguageCodeItem> languageCodes) {
            this.languageCodes = LanguageCodeListCopier.copy(languageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languageCodes(LanguageCodeItem ... languageCodes) {
            this.languageCodes(Arrays.asList(languageCodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languageCodes(Consumer<LanguageCodeItem.Builder> ... languageCodes) {
            this.languageCodes(Stream.of(languageCodes).map(c -> (LanguageCodeItem)((LanguageCodeItem.Builder)LanguageCodeItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ToxicityDetectionSettings.Builder> getToxicityDetection() {
            List<ToxicityDetectionSettings.Builder> result = ToxicityDetectionCopier.copyToBuilder(this.toxicityDetection);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToxicityDetection(Collection<ToxicityDetectionSettings.BuilderImpl> toxicityDetection) {
            this.toxicityDetection = ToxicityDetectionCopier.copyFromBuilder(toxicityDetection);
        }

        @Override
        public final Builder toxicityDetection(Collection<ToxicityDetectionSettings> toxicityDetection) {
            this.toxicityDetection = ToxicityDetectionCopier.copy(toxicityDetection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toxicityDetection(ToxicityDetectionSettings ... toxicityDetection) {
            this.toxicityDetection(Arrays.asList(toxicityDetection));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toxicityDetection(Consumer<ToxicityDetectionSettings.Builder> ... toxicityDetection) {
            this.toxicityDetection(Stream.of(toxicityDetection).map(c -> (ToxicityDetectionSettings)((ToxicityDetectionSettings.Builder)ToxicityDetectionSettings.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TranscriptionJobSummary build() {
            return new TranscriptionJobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TranscriptionJobSummary> {
        public Builder transcriptionJobName(String var1);

        public Builder creationTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder completionTime(Instant var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder transcriptionJobStatus(String var1);

        public Builder transcriptionJobStatus(TranscriptionJobStatus var1);

        public Builder failureReason(String var1);

        public Builder outputLocationType(String var1);

        public Builder outputLocationType(OutputLocationType var1);

        public Builder contentRedaction(ContentRedaction var1);

        default public Builder contentRedaction(Consumer<ContentRedaction.Builder> contentRedaction) {
            return this.contentRedaction((ContentRedaction)((ContentRedaction.Builder)ContentRedaction.builder().applyMutation(contentRedaction)).build());
        }

        public Builder modelSettings(ModelSettings var1);

        default public Builder modelSettings(Consumer<ModelSettings.Builder> modelSettings) {
            return this.modelSettings((ModelSettings)((ModelSettings.Builder)ModelSettings.builder().applyMutation(modelSettings)).build());
        }

        public Builder identifyLanguage(Boolean var1);

        public Builder identifyMultipleLanguages(Boolean var1);

        public Builder identifiedLanguageScore(Float var1);

        public Builder languageCodes(Collection<LanguageCodeItem> var1);

        public Builder languageCodes(LanguageCodeItem ... var1);

        public Builder languageCodes(Consumer<LanguageCodeItem.Builder> ... var1);

        public Builder toxicityDetection(Collection<ToxicityDetectionSettings> var1);

        public Builder toxicityDetection(ToxicityDetectionSettings ... var1);

        public Builder toxicityDetection(Consumer<ToxicityDetectionSettings.Builder> ... var1);
    }
}

