/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.LanguageModel;
import software.amazon.awssdk.services.transcribe.model.TranscribeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLanguageModelResponse
extends TranscribeResponse
implements ToCopyableBuilder<Builder, DescribeLanguageModelResponse> {
    private static final SdkField<LanguageModel> LANGUAGE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LanguageModel").getter(DescribeLanguageModelResponse.getter(DescribeLanguageModelResponse::languageModel)).setter(DescribeLanguageModelResponse.setter(Builder::languageModel)).constructor(LanguageModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageModel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_MODEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LanguageModel", LANGUAGE_MODEL_FIELD);
        }
    });
    private final LanguageModel languageModel;

    private DescribeLanguageModelResponse(BuilderImpl builder) {
        super(builder);
        this.languageModel = builder.languageModel;
    }

    public final LanguageModel languageModel() {
        return this.languageModel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.languageModel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLanguageModelResponse)) {
            return false;
        }
        DescribeLanguageModelResponse other = (DescribeLanguageModelResponse)((Object)obj);
        return Objects.equals(this.languageModel(), other.languageModel());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLanguageModelResponse").add("LanguageModel", (Object)this.languageModel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageModel": {
                return Optional.ofNullable(clazz.cast(this.languageModel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLanguageModelResponse, T> g) {
        return obj -> g.apply((DescribeLanguageModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeResponse.BuilderImpl
    implements Builder {
        private LanguageModel languageModel;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLanguageModelResponse model) {
            super(model);
            this.languageModel(model.languageModel);
        }

        public final LanguageModel.Builder getLanguageModel() {
            return this.languageModel != null ? this.languageModel.toBuilder() : null;
        }

        public final void setLanguageModel(LanguageModel.BuilderImpl languageModel) {
            this.languageModel = languageModel != null ? languageModel.build() : null;
        }

        @Override
        public final Builder languageModel(LanguageModel languageModel) {
            this.languageModel = languageModel;
            return this;
        }

        @Override
        public DescribeLanguageModelResponse build() {
            return new DescribeLanguageModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TranscribeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLanguageModelResponse> {
        public Builder languageModel(LanguageModel var1);

        default public Builder languageModel(Consumer<LanguageModel.Builder> languageModel) {
            return this.languageModel((LanguageModel)((LanguageModel.Builder)LanguageModel.builder().applyMutation(languageModel)).build());
        }
    }
}

