/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.timestreamwrite.model.BatchLoadProgressReport;
import software.amazon.awssdk.services.timestreamwrite.model.BatchLoadStatus;
import software.amazon.awssdk.services.timestreamwrite.model.DataModelConfiguration;
import software.amazon.awssdk.services.timestreamwrite.model.DataSourceConfiguration;
import software.amazon.awssdk.services.timestreamwrite.model.ReportConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchLoadTaskDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchLoadTaskDescription> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskId").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::taskId)).setter(BatchLoadTaskDescription.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskId").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::errorMessage)).setter(BatchLoadTaskDescription.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceConfiguration").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::dataSourceConfiguration)).setter(BatchLoadTaskDescription.setter(Builder::dataSourceConfiguration)).constructor(DataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceConfiguration").build()}).build();
    private static final SdkField<BatchLoadProgressReport> PROGRESS_REPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProgressReport").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::progressReport)).setter(BatchLoadTaskDescription.setter(Builder::progressReport)).constructor(BatchLoadProgressReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressReport").build()}).build();
    private static final SdkField<ReportConfiguration> REPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReportConfiguration").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::reportConfiguration)).setter(BatchLoadTaskDescription.setter(Builder::reportConfiguration)).constructor(ReportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportConfiguration").build()}).build();
    private static final SdkField<DataModelConfiguration> DATA_MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataModelConfiguration").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::dataModelConfiguration)).setter(BatchLoadTaskDescription.setter(Builder::dataModelConfiguration)).constructor(DataModelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataModelConfiguration").build()}).build();
    private static final SdkField<String> TARGET_DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDatabaseName").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::targetDatabaseName)).setter(BatchLoadTaskDescription.setter(Builder::targetDatabaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDatabaseName").build()}).build();
    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetTableName").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::targetTableName)).setter(BatchLoadTaskDescription.setter(Builder::targetTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()}).build();
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskStatus").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::taskStatusAsString)).setter(BatchLoadTaskDescription.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build()}).build();
    private static final SdkField<Long> RECORD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RecordVersion").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::recordVersion)).setter(BatchLoadTaskDescription.setter(Builder::recordVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordVersion").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::creationTime)).setter(BatchLoadTaskDescription.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::lastUpdatedTime)).setter(BatchLoadTaskDescription.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<Instant> RESUMABLE_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ResumableUntil").getter(BatchLoadTaskDescription.getter(BatchLoadTaskDescription::resumableUntil)).setter(BatchLoadTaskDescription.setter(Builder::resumableUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResumableUntil").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, ERROR_MESSAGE_FIELD, DATA_SOURCE_CONFIGURATION_FIELD, PROGRESS_REPORT_FIELD, REPORT_CONFIGURATION_FIELD, DATA_MODEL_CONFIGURATION_FIELD, TARGET_DATABASE_NAME_FIELD, TARGET_TABLE_NAME_FIELD, TASK_STATUS_FIELD, RECORD_VERSION_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, RESUMABLE_UNTIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TaskId", TASK_ID_FIELD);
            this.put("ErrorMessage", ERROR_MESSAGE_FIELD);
            this.put("DataSourceConfiguration", DATA_SOURCE_CONFIGURATION_FIELD);
            this.put("ProgressReport", PROGRESS_REPORT_FIELD);
            this.put("ReportConfiguration", REPORT_CONFIGURATION_FIELD);
            this.put("DataModelConfiguration", DATA_MODEL_CONFIGURATION_FIELD);
            this.put("TargetDatabaseName", TARGET_DATABASE_NAME_FIELD);
            this.put("TargetTableName", TARGET_TABLE_NAME_FIELD);
            this.put("TaskStatus", TASK_STATUS_FIELD);
            this.put("RecordVersion", RECORD_VERSION_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
            this.put("ResumableUntil", RESUMABLE_UNTIL_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final String errorMessage;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final BatchLoadProgressReport progressReport;
    private final ReportConfiguration reportConfiguration;
    private final DataModelConfiguration dataModelConfiguration;
    private final String targetDatabaseName;
    private final String targetTableName;
    private final String taskStatus;
    private final Long recordVersion;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final Instant resumableUntil;

    private BatchLoadTaskDescription(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.errorMessage = builder.errorMessage;
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.progressReport = builder.progressReport;
        this.reportConfiguration = builder.reportConfiguration;
        this.dataModelConfiguration = builder.dataModelConfiguration;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetTableName = builder.targetTableName;
        this.taskStatus = builder.taskStatus;
        this.recordVersion = builder.recordVersion;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.resumableUntil = builder.resumableUntil;
    }

    public final String taskId() {
        return this.taskId;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final DataSourceConfiguration dataSourceConfiguration() {
        return this.dataSourceConfiguration;
    }

    public final BatchLoadProgressReport progressReport() {
        return this.progressReport;
    }

    public final ReportConfiguration reportConfiguration() {
        return this.reportConfiguration;
    }

    public final DataModelConfiguration dataModelConfiguration() {
        return this.dataModelConfiguration;
    }

    public final String targetDatabaseName() {
        return this.targetDatabaseName;
    }

    public final String targetTableName() {
        return this.targetTableName;
    }

    public final BatchLoadStatus taskStatus() {
        return BatchLoadStatus.fromValue(this.taskStatus);
    }

    public final String taskStatusAsString() {
        return this.taskStatus;
    }

    public final Long recordVersion() {
        return this.recordVersion;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final Instant resumableUntil() {
        return this.resumableUntil;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressReport());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resumableUntil());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchLoadTaskDescription)) {
            return false;
        }
        BatchLoadTaskDescription other = (BatchLoadTaskDescription)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.dataSourceConfiguration(), other.dataSourceConfiguration()) && Objects.equals(this.progressReport(), other.progressReport()) && Objects.equals(this.reportConfiguration(), other.reportConfiguration()) && Objects.equals(this.dataModelConfiguration(), other.dataModelConfiguration()) && Objects.equals(this.targetDatabaseName(), other.targetDatabaseName()) && Objects.equals(this.targetTableName(), other.targetTableName()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString()) && Objects.equals(this.recordVersion(), other.recordVersion()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.resumableUntil(), other.resumableUntil());
    }

    public final String toString() {
        return ToString.builder((String)"BatchLoadTaskDescription").add("TaskId", (Object)this.taskId()).add("ErrorMessage", (Object)this.errorMessage()).add("DataSourceConfiguration", (Object)this.dataSourceConfiguration()).add("ProgressReport", (Object)this.progressReport()).add("ReportConfiguration", (Object)this.reportConfiguration()).add("DataModelConfiguration", (Object)this.dataModelConfiguration()).add("TargetDatabaseName", (Object)this.targetDatabaseName()).add("TargetTableName", (Object)this.targetTableName()).add("TaskStatus", (Object)this.taskStatusAsString()).add("RecordVersion", (Object)this.recordVersion()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("ResumableUntil", (Object)this.resumableUntil()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "DataSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataSourceConfiguration()));
            }
            case "ProgressReport": {
                return Optional.ofNullable(clazz.cast(this.progressReport()));
            }
            case "ReportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.reportConfiguration()));
            }
            case "DataModelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataModelConfiguration()));
            }
            case "TargetDatabaseName": {
                return Optional.ofNullable(clazz.cast(this.targetDatabaseName()));
            }
            case "TargetTableName": {
                return Optional.ofNullable(clazz.cast(this.targetTableName()));
            }
            case "TaskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
            case "RecordVersion": {
                return Optional.ofNullable(clazz.cast(this.recordVersion()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "ResumableUntil": {
                return Optional.ofNullable(clazz.cast(this.resumableUntil()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchLoadTaskDescription, T> g) {
        return obj -> g.apply((BatchLoadTaskDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private String errorMessage;
        private DataSourceConfiguration dataSourceConfiguration;
        private BatchLoadProgressReport progressReport;
        private ReportConfiguration reportConfiguration;
        private DataModelConfiguration dataModelConfiguration;
        private String targetDatabaseName;
        private String targetTableName;
        private String taskStatus;
        private Long recordVersion;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private Instant resumableUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchLoadTaskDescription model) {
            this.taskId(model.taskId);
            this.errorMessage(model.errorMessage);
            this.dataSourceConfiguration(model.dataSourceConfiguration);
            this.progressReport(model.progressReport);
            this.reportConfiguration(model.reportConfiguration);
            this.dataModelConfiguration(model.dataModelConfiguration);
            this.targetDatabaseName(model.targetDatabaseName);
            this.targetTableName(model.targetTableName);
            this.taskStatus(model.taskStatus);
            this.recordVersion(model.recordVersion);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.resumableUntil(model.resumableUntil);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return this.dataSourceConfiguration != null ? this.dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final BatchLoadProgressReport.Builder getProgressReport() {
            return this.progressReport != null ? this.progressReport.toBuilder() : null;
        }

        public final void setProgressReport(BatchLoadProgressReport.BuilderImpl progressReport) {
            this.progressReport = progressReport != null ? progressReport.build() : null;
        }

        @Override
        public final Builder progressReport(BatchLoadProgressReport progressReport) {
            this.progressReport = progressReport;
            return this;
        }

        public final ReportConfiguration.Builder getReportConfiguration() {
            return this.reportConfiguration != null ? this.reportConfiguration.toBuilder() : null;
        }

        public final void setReportConfiguration(ReportConfiguration.BuilderImpl reportConfiguration) {
            this.reportConfiguration = reportConfiguration != null ? reportConfiguration.build() : null;
        }

        @Override
        public final Builder reportConfiguration(ReportConfiguration reportConfiguration) {
            this.reportConfiguration = reportConfiguration;
            return this;
        }

        public final DataModelConfiguration.Builder getDataModelConfiguration() {
            return this.dataModelConfiguration != null ? this.dataModelConfiguration.toBuilder() : null;
        }

        public final void setDataModelConfiguration(DataModelConfiguration.BuilderImpl dataModelConfiguration) {
            this.dataModelConfiguration = dataModelConfiguration != null ? dataModelConfiguration.build() : null;
        }

        @Override
        public final Builder dataModelConfiguration(DataModelConfiguration dataModelConfiguration) {
            this.dataModelConfiguration = dataModelConfiguration;
            return this;
        }

        public final String getTargetDatabaseName() {
            return this.targetDatabaseName;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final String getTargetTableName() {
            return this.targetTableName;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(BatchLoadStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final Long getRecordVersion() {
            return this.recordVersion;
        }

        public final void setRecordVersion(Long recordVersion) {
            this.recordVersion = recordVersion;
        }

        @Override
        public final Builder recordVersion(Long recordVersion) {
            this.recordVersion = recordVersion;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getResumableUntil() {
            return this.resumableUntil;
        }

        public final void setResumableUntil(Instant resumableUntil) {
            this.resumableUntil = resumableUntil;
        }

        @Override
        public final Builder resumableUntil(Instant resumableUntil) {
            this.resumableUntil = resumableUntil;
            return this;
        }

        public BatchLoadTaskDescription build() {
            return new BatchLoadTaskDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchLoadTaskDescription> {
        public Builder taskId(String var1);

        public Builder errorMessage(String var1);

        public Builder dataSourceConfiguration(DataSourceConfiguration var1);

        default public Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return this.dataSourceConfiguration((DataSourceConfiguration)((DataSourceConfiguration.Builder)DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration)).build());
        }

        public Builder progressReport(BatchLoadProgressReport var1);

        default public Builder progressReport(Consumer<BatchLoadProgressReport.Builder> progressReport) {
            return this.progressReport((BatchLoadProgressReport)((BatchLoadProgressReport.Builder)BatchLoadProgressReport.builder().applyMutation(progressReport)).build());
        }

        public Builder reportConfiguration(ReportConfiguration var1);

        default public Builder reportConfiguration(Consumer<ReportConfiguration.Builder> reportConfiguration) {
            return this.reportConfiguration((ReportConfiguration)((ReportConfiguration.Builder)ReportConfiguration.builder().applyMutation(reportConfiguration)).build());
        }

        public Builder dataModelConfiguration(DataModelConfiguration var1);

        default public Builder dataModelConfiguration(Consumer<DataModelConfiguration.Builder> dataModelConfiguration) {
            return this.dataModelConfiguration((DataModelConfiguration)((DataModelConfiguration.Builder)DataModelConfiguration.builder().applyMutation(dataModelConfiguration)).build());
        }

        public Builder targetDatabaseName(String var1);

        public Builder targetTableName(String var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(BatchLoadStatus var1);

        public Builder recordVersion(Long var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder resumableUntil(Instant var1);
    }
}

