/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryAsyncClient;
import software.amazon.awssdk.services.timestreamquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesRequest;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesResponse;
import software.amazon.awssdk.services.timestreamquery.model.ScheduledQuery;

public class ListScheduledQueriesPublisher
implements SdkPublisher<ListScheduledQueriesResponse> {
    private final TimestreamQueryAsyncClient client;
    private final ListScheduledQueriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScheduledQueriesPublisher(TimestreamQueryAsyncClient client, ListScheduledQueriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScheduledQueriesPublisher(TimestreamQueryAsyncClient client, ListScheduledQueriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScheduledQueriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScheduledQueriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduledQuery> scheduledQueries() {
        Function<ListScheduledQueriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledQueries() != null) {
                return response.scheduledQueries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListScheduledQueriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListScheduledQueriesResponseFetcher
    implements AsyncPageFetcher<ListScheduledQueriesResponse> {
        private ListScheduledQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListScheduledQueriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScheduledQueriesResponse> nextPage(ListScheduledQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListScheduledQueriesPublisher.this.client.listScheduledQueries(ListScheduledQueriesPublisher.this.firstRequest);
            }
            return ListScheduledQueriesPublisher.this.client.listScheduledQueries((ListScheduledQueriesRequest)((Object)ListScheduledQueriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

