/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.synthetics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.synthetics.SyntheticsClient;
import software.amazon.awssdk.services.synthetics.internal.UserAgentUtils;
import software.amazon.awssdk.services.synthetics.model.GetCanaryRunsRequest;
import software.amazon.awssdk.services.synthetics.model.GetCanaryRunsResponse;

public class GetCanaryRunsIterable
implements SdkIterable<GetCanaryRunsResponse> {
    private final SyntheticsClient client;
    private final GetCanaryRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCanaryRunsIterable(SyntheticsClient client, GetCanaryRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCanaryRunsResponseFetcher();
    }

    public Iterator<GetCanaryRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetCanaryRunsResponseFetcher
    implements SyncPageFetcher<GetCanaryRunsResponse> {
        private GetCanaryRunsResponseFetcher() {
        }

        public boolean hasNextPage(GetCanaryRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCanaryRunsResponse nextPage(GetCanaryRunsResponse previousPage) {
            if (previousPage == null) {
                return GetCanaryRunsIterable.this.client.getCanaryRuns(GetCanaryRunsIterable.this.firstRequest);
            }
            return GetCanaryRunsIterable.this.client.getCanaryRuns((GetCanaryRunsRequest)((Object)GetCanaryRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

