/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.support.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.support.model.SupportResponse;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCheckSummary;
import software.amazon.awssdk.services.support.model.TrustedAdvisorCheckSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrustedAdvisorCheckSummariesResponse
extends SupportResponse
implements ToCopyableBuilder<Builder, DescribeTrustedAdvisorCheckSummariesResponse> {
    private static final SdkField<List<TrustedAdvisorCheckSummary>> SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("summaries").getter(DescribeTrustedAdvisorCheckSummariesResponse.getter(DescribeTrustedAdvisorCheckSummariesResponse::summaries)).setter(DescribeTrustedAdvisorCheckSummariesResponse.setter(Builder::summaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustedAdvisorCheckSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("summaries", SUMMARIES_FIELD);
        }
    });
    private final List<TrustedAdvisorCheckSummary> summaries;

    private DescribeTrustedAdvisorCheckSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
    }

    public final boolean hasSummaries() {
        return this.summaries != null && !(this.summaries instanceof SdkAutoConstructList);
    }

    public final List<TrustedAdvisorCheckSummary> summaries() {
        return this.summaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaries() ? this.summaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrustedAdvisorCheckSummariesResponse)) {
            return false;
        }
        DescribeTrustedAdvisorCheckSummariesResponse other = (DescribeTrustedAdvisorCheckSummariesResponse)((Object)obj);
        return this.hasSummaries() == other.hasSummaries() && Objects.equals(this.summaries(), other.summaries());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrustedAdvisorCheckSummariesResponse").add("Summaries", this.hasSummaries() ? this.summaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "summaries": {
                return Optional.ofNullable(clazz.cast(this.summaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrustedAdvisorCheckSummariesResponse, T> g) {
        return obj -> g.apply((DescribeTrustedAdvisorCheckSummariesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportResponse.BuilderImpl
    implements Builder {
        private List<TrustedAdvisorCheckSummary> summaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrustedAdvisorCheckSummariesResponse model) {
            super(model);
            this.summaries(model.summaries);
        }

        public final List<TrustedAdvisorCheckSummary.Builder> getSummaries() {
            List<TrustedAdvisorCheckSummary.Builder> result = TrustedAdvisorCheckSummaryListCopier.copyToBuilder(this.summaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaries(Collection<TrustedAdvisorCheckSummary.BuilderImpl> summaries) {
            this.summaries = TrustedAdvisorCheckSummaryListCopier.copyFromBuilder(summaries);
        }

        @Override
        public final Builder summaries(Collection<TrustedAdvisorCheckSummary> summaries) {
            this.summaries = TrustedAdvisorCheckSummaryListCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(TrustedAdvisorCheckSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<TrustedAdvisorCheckSummary.Builder> ... summaries) {
            this.summaries(Stream.of(summaries).map(c -> (TrustedAdvisorCheckSummary)((TrustedAdvisorCheckSummary.Builder)TrustedAdvisorCheckSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTrustedAdvisorCheckSummariesResponse build() {
            return new DescribeTrustedAdvisorCheckSummariesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SupportResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrustedAdvisorCheckSummariesResponse> {
        public Builder summaries(Collection<TrustedAdvisorCheckSummary> var1);

        public Builder summaries(TrustedAdvisorCheckSummary ... var1);

        public Builder summaries(Consumer<TrustedAdvisorCheckSummary.Builder> ... var1);
    }
}

