/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBandwidthRateLimitRequest
extends StorageGatewayRequest
implements ToCopyableBuilder<Builder, UpdateBandwidthRateLimitRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(UpdateBandwidthRateLimitRequest.getter(UpdateBandwidthRateLimitRequest::gatewayARN)).setter(UpdateBandwidthRateLimitRequest.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<Long> AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AverageUploadRateLimitInBitsPerSec").getter(UpdateBandwidthRateLimitRequest.getter(UpdateBandwidthRateLimitRequest::averageUploadRateLimitInBitsPerSec)).setter(UpdateBandwidthRateLimitRequest.setter(Builder::averageUploadRateLimitInBitsPerSec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageUploadRateLimitInBitsPerSec").build()}).build();
    private static final SdkField<Long> AVERAGE_DOWNLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AverageDownloadRateLimitInBitsPerSec").getter(UpdateBandwidthRateLimitRequest.getter(UpdateBandwidthRateLimitRequest::averageDownloadRateLimitInBitsPerSec)).setter(UpdateBandwidthRateLimitRequest.setter(Builder::averageDownloadRateLimitInBitsPerSec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageDownloadRateLimitInBitsPerSec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD, AVERAGE_DOWNLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GatewayARN", GATEWAY_ARN_FIELD);
            this.put("AverageUploadRateLimitInBitsPerSec", AVERAGE_UPLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD);
            this.put("AverageDownloadRateLimitInBitsPerSec", AVERAGE_DOWNLOAD_RATE_LIMIT_IN_BITS_PER_SEC_FIELD);
        }
    });
    private final String gatewayARN;
    private final Long averageUploadRateLimitInBitsPerSec;
    private final Long averageDownloadRateLimitInBitsPerSec;

    private UpdateBandwidthRateLimitRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.averageUploadRateLimitInBitsPerSec = builder.averageUploadRateLimitInBitsPerSec;
        this.averageDownloadRateLimitInBitsPerSec = builder.averageDownloadRateLimitInBitsPerSec;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final Long averageUploadRateLimitInBitsPerSec() {
        return this.averageUploadRateLimitInBitsPerSec;
    }

    public final Long averageDownloadRateLimitInBitsPerSec() {
        return this.averageDownloadRateLimitInBitsPerSec;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.averageUploadRateLimitInBitsPerSec());
        hashCode = 31 * hashCode + Objects.hashCode(this.averageDownloadRateLimitInBitsPerSec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBandwidthRateLimitRequest)) {
            return false;
        }
        UpdateBandwidthRateLimitRequest other = (UpdateBandwidthRateLimitRequest)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.averageUploadRateLimitInBitsPerSec(), other.averageUploadRateLimitInBitsPerSec()) && Objects.equals(this.averageDownloadRateLimitInBitsPerSec(), other.averageDownloadRateLimitInBitsPerSec());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBandwidthRateLimitRequest").add("GatewayARN", (Object)this.gatewayARN()).add("AverageUploadRateLimitInBitsPerSec", (Object)this.averageUploadRateLimitInBitsPerSec()).add("AverageDownloadRateLimitInBitsPerSec", (Object)this.averageDownloadRateLimitInBitsPerSec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "AverageUploadRateLimitInBitsPerSec": {
                return Optional.ofNullable(clazz.cast(this.averageUploadRateLimitInBitsPerSec()));
            }
            case "AverageDownloadRateLimitInBitsPerSec": {
                return Optional.ofNullable(clazz.cast(this.averageDownloadRateLimitInBitsPerSec()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBandwidthRateLimitRequest, T> g) {
        return obj -> g.apply((UpdateBandwidthRateLimitRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private Long averageUploadRateLimitInBitsPerSec;
        private Long averageDownloadRateLimitInBitsPerSec;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBandwidthRateLimitRequest model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.averageUploadRateLimitInBitsPerSec(model.averageUploadRateLimitInBitsPerSec);
            this.averageDownloadRateLimitInBitsPerSec(model.averageDownloadRateLimitInBitsPerSec);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final Long getAverageUploadRateLimitInBitsPerSec() {
            return this.averageUploadRateLimitInBitsPerSec;
        }

        public final void setAverageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
        }

        @Override
        public final Builder averageUploadRateLimitInBitsPerSec(Long averageUploadRateLimitInBitsPerSec) {
            this.averageUploadRateLimitInBitsPerSec = averageUploadRateLimitInBitsPerSec;
            return this;
        }

        public final Long getAverageDownloadRateLimitInBitsPerSec() {
            return this.averageDownloadRateLimitInBitsPerSec;
        }

        public final void setAverageDownloadRateLimitInBitsPerSec(Long averageDownloadRateLimitInBitsPerSec) {
            this.averageDownloadRateLimitInBitsPerSec = averageDownloadRateLimitInBitsPerSec;
        }

        @Override
        public final Builder averageDownloadRateLimitInBitsPerSec(Long averageDownloadRateLimitInBitsPerSec) {
            this.averageDownloadRateLimitInBitsPerSec = averageDownloadRateLimitInBitsPerSec;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBandwidthRateLimitRequest build() {
            return new UpdateBandwidthRateLimitRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBandwidthRateLimitRequest> {
        public Builder gatewayARN(String var1);

        public Builder averageUploadRateLimitInBitsPerSec(Long var1);

        public Builder averageDownloadRateLimitInBitsPerSec(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

