/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.storagegateway.model.AvailabilityMonitorTestStatus;
import software.amazon.awssdk.services.storagegateway.model.StorageGatewayResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAvailabilityMonitorTestResponse
extends StorageGatewayResponse
implements ToCopyableBuilder<Builder, DescribeAvailabilityMonitorTestResponse> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayARN").getter(DescribeAvailabilityMonitorTestResponse.getter(DescribeAvailabilityMonitorTestResponse::gatewayARN)).setter(DescribeAvailabilityMonitorTestResponse.setter(Builder::gatewayARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeAvailabilityMonitorTestResponse.getter(DescribeAvailabilityMonitorTestResponse::statusAsString)).setter(DescribeAvailabilityMonitorTestResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(DescribeAvailabilityMonitorTestResponse.getter(DescribeAvailabilityMonitorTestResponse::startTime)).setter(DescribeAvailabilityMonitorTestResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, STATUS_FIELD, START_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GatewayARN", GATEWAY_ARN_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StartTime", START_TIME_FIELD);
        }
    });
    private final String gatewayARN;
    private final String status;
    private final Instant startTime;

    private DescribeAvailabilityMonitorTestResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.status = builder.status;
        this.startTime = builder.startTime;
    }

    public final String gatewayARN() {
        return this.gatewayARN;
    }

    public final AvailabilityMonitorTestStatus status() {
        return AvailabilityMonitorTestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailabilityMonitorTestResponse)) {
            return false;
        }
        DescribeAvailabilityMonitorTestResponse other = (DescribeAvailabilityMonitorTestResponse)((Object)obj);
        return Objects.equals(this.gatewayARN(), other.gatewayARN()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAvailabilityMonitorTestResponse").add("GatewayARN", (Object)this.gatewayARN()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayARN": {
                return Optional.ofNullable(clazz.cast(this.gatewayARN()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAvailabilityMonitorTestResponse, T> g) {
        return obj -> g.apply((DescribeAvailabilityMonitorTestResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends StorageGatewayResponse.BuilderImpl
    implements Builder {
        private String gatewayARN;
        private String status;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailabilityMonitorTestResponse model) {
            super(model);
            this.gatewayARN(model.gatewayARN);
            this.status(model.status);
            this.startTime(model.startTime);
        }

        public final String getGatewayARN() {
            return this.gatewayARN;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AvailabilityMonitorTestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public DescribeAvailabilityMonitorTestResponse build() {
            return new DescribeAvailabilityMonitorTestResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends StorageGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAvailabilityMonitorTestResponse> {
        public Builder gatewayARN(String var1);

        public Builder status(String var1);

        public Builder status(AvailabilityMonitorTestStatus var1);

        public Builder startTime(Instant var1);
    }
}

