/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.ResourcePolicy;
import software.amazon.awssdk.services.ssmincidents.model.ResourcePolicyListCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcePoliciesResponse
extends SsmIncidentsResponse
implements ToCopyableBuilder<Builder, GetResourcePoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetResourcePoliciesResponse.getter(GetResourcePoliciesResponse::nextToken)).setter(GetResourcePoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ResourcePolicy>> RESOURCE_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourcePolicies").getter(GetResourcePoliciesResponse.getter(GetResourcePoliciesResponse::resourcePolicies)).setter(GetResourcePoliciesResponse.setter(Builder::resourcePolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcePolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESOURCE_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("resourcePolicies", RESOURCE_POLICIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<ResourcePolicy> resourcePolicies;

    private GetResourcePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resourcePolicies = builder.resourcePolicies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasResourcePolicies() {
        return this.resourcePolicies != null && !(this.resourcePolicies instanceof SdkAutoConstructList);
    }

    public final List<ResourcePolicy> resourcePolicies() {
        return this.resourcePolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourcePolicies() ? this.resourcePolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcePoliciesResponse)) {
            return false;
        }
        GetResourcePoliciesResponse other = (GetResourcePoliciesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasResourcePolicies() == other.hasResourcePolicies() && Objects.equals(this.resourcePolicies(), other.resourcePolicies());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcePoliciesResponse").add("NextToken", (Object)this.nextToken()).add("ResourcePolicies", this.hasResourcePolicies() ? this.resourcePolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resourcePolicies": {
                return Optional.ofNullable(clazz.cast(this.resourcePolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetResourcePoliciesResponse, T> g) {
        return obj -> g.apply((GetResourcePoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ResourcePolicy> resourcePolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcePoliciesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.resourcePolicies(model.resourcePolicies);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResourcePolicy.Builder> getResourcePolicies() {
            List<ResourcePolicy.Builder> result = ResourcePolicyListCopier.copyToBuilder(this.resourcePolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourcePolicies(Collection<ResourcePolicy.BuilderImpl> resourcePolicies) {
            this.resourcePolicies = ResourcePolicyListCopier.copyFromBuilder(resourcePolicies);
        }

        @Override
        public final Builder resourcePolicies(Collection<ResourcePolicy> resourcePolicies) {
            this.resourcePolicies = ResourcePolicyListCopier.copy(resourcePolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePolicies(ResourcePolicy ... resourcePolicies) {
            this.resourcePolicies(Arrays.asList(resourcePolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcePolicies(Consumer<ResourcePolicy.Builder> ... resourcePolicies) {
            this.resourcePolicies(Stream.of(resourcePolicies).map(c -> (ResourcePolicy)((ResourcePolicy.Builder)ResourcePolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetResourcePoliciesResponse build() {
            return new GetResourcePoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmIncidentsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcePoliciesResponse> {
        public Builder nextToken(String var1);

        public Builder resourcePolicies(Collection<ResourcePolicy> var1);

        public Builder resourcePolicies(ResourcePolicy ... var1);

        public Builder resourcePolicies(Consumer<ResourcePolicy.Builder> ... var1);
    }
}

