/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.DayOfWeek;
import software.amazon.awssdk.services.ssmcontacts.model.HandOffTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WeeklySetting
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WeeklySetting> {
    private static final SdkField<String> DAY_OF_WEEK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DayOfWeek").getter(WeeklySetting.getter(WeeklySetting::dayOfWeekAsString)).setter(WeeklySetting.setter(Builder::dayOfWeek)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfWeek").build()}).build();
    private static final SdkField<HandOffTime> HAND_OFF_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HandOffTime").getter(WeeklySetting.getter(WeeklySetting::handOffTime)).setter(WeeklySetting.setter(Builder::handOffTime)).constructor(HandOffTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HandOffTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_WEEK_FIELD, HAND_OFF_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DayOfWeek", DAY_OF_WEEK_FIELD);
            this.put("HandOffTime", HAND_OFF_TIME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dayOfWeek;
    private final HandOffTime handOffTime;

    private WeeklySetting(BuilderImpl builder) {
        this.dayOfWeek = builder.dayOfWeek;
        this.handOffTime = builder.handOffTime;
    }

    public final DayOfWeek dayOfWeek() {
        return DayOfWeek.fromValue(this.dayOfWeek);
    }

    public final String dayOfWeekAsString() {
        return this.dayOfWeek;
    }

    public final HandOffTime handOffTime() {
        return this.handOffTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dayOfWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.handOffTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklySetting)) {
            return false;
        }
        WeeklySetting other = (WeeklySetting)obj;
        return Objects.equals(this.dayOfWeekAsString(), other.dayOfWeekAsString()) && Objects.equals(this.handOffTime(), other.handOffTime());
    }

    public final String toString() {
        return ToString.builder((String)"WeeklySetting").add("DayOfWeek", (Object)this.dayOfWeekAsString()).add("HandOffTime", (Object)this.handOffTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DayOfWeek": {
                return Optional.ofNullable(clazz.cast(this.dayOfWeekAsString()));
            }
            case "HandOffTime": {
                return Optional.ofNullable(clazz.cast(this.handOffTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WeeklySetting, T> g) {
        return obj -> g.apply((WeeklySetting)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dayOfWeek;
        private HandOffTime handOffTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklySetting model) {
            this.dayOfWeek(model.dayOfWeek);
            this.handOffTime(model.handOffTime);
        }

        public final String getDayOfWeek() {
            return this.dayOfWeek;
        }

        public final void setDayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public final Builder dayOfWeek(String dayOfWeek) {
            this.dayOfWeek = dayOfWeek;
            return this;
        }

        @Override
        public final Builder dayOfWeek(DayOfWeek dayOfWeek) {
            this.dayOfWeek(dayOfWeek == null ? null : dayOfWeek.toString());
            return this;
        }

        public final HandOffTime.Builder getHandOffTime() {
            return this.handOffTime != null ? this.handOffTime.toBuilder() : null;
        }

        public final void setHandOffTime(HandOffTime.BuilderImpl handOffTime) {
            this.handOffTime = handOffTime != null ? handOffTime.build() : null;
        }

        @Override
        public final Builder handOffTime(HandOffTime handOffTime) {
            this.handOffTime = handOffTime;
            return this;
        }

        public WeeklySetting build() {
            return new WeeklySetting(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WeeklySetting> {
        public Builder dayOfWeek(String var1);

        public Builder dayOfWeek(DayOfWeek var1);

        public Builder handOffTime(HandOffTime var1);

        default public Builder handOffTime(Consumer<HandOffTime.Builder> handOffTime) {
            return this.handOffTime((HandOffTime)((HandOffTime.Builder)HandOffTime.builder().applyMutation(handOffTime)).build());
        }
    }
}

