/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.RotationOverrideContactsArnListCopier;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRotationOverrideRequest
extends SsmContactsRequest
implements ToCopyableBuilder<Builder, CreateRotationOverrideRequest> {
    private static final SdkField<String> ROTATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RotationId").getter(CreateRotationOverrideRequest.getter(CreateRotationOverrideRequest::rotationId)).setter(CreateRotationOverrideRequest.setter(Builder::rotationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationId").build()}).build();
    private static final SdkField<List<String>> NEW_CONTACT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NewContactIds").getter(CreateRotationOverrideRequest.getter(CreateRotationOverrideRequest::newContactIds)).setter(CreateRotationOverrideRequest.setter(Builder::newContactIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewContactIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(CreateRotationOverrideRequest.getter(CreateRotationOverrideRequest::startTime)).setter(CreateRotationOverrideRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(CreateRotationOverrideRequest.getter(CreateRotationOverrideRequest::endTime)).setter(CreateRotationOverrideRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdempotencyToken").getter(CreateRotationOverrideRequest.getter(CreateRotationOverrideRequest::idempotencyToken)).setter(CreateRotationOverrideRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_ID_FIELD, NEW_CONTACT_IDS_FIELD, START_TIME_FIELD, END_TIME_FIELD, IDEMPOTENCY_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RotationId", ROTATION_ID_FIELD);
            this.put("NewContactIds", NEW_CONTACT_IDS_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        }
    });
    private final String rotationId;
    private final List<String> newContactIds;
    private final Instant startTime;
    private final Instant endTime;
    private final String idempotencyToken;

    private CreateRotationOverrideRequest(BuilderImpl builder) {
        super(builder);
        this.rotationId = builder.rotationId;
        this.newContactIds = builder.newContactIds;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public final String rotationId() {
        return this.rotationId;
    }

    public final boolean hasNewContactIds() {
        return this.newContactIds != null && !(this.newContactIds instanceof SdkAutoConstructList);
    }

    public final List<String> newContactIds() {
        return this.newContactIds;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNewContactIds() ? this.newContactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRotationOverrideRequest)) {
            return false;
        }
        CreateRotationOverrideRequest other = (CreateRotationOverrideRequest)((Object)obj);
        return Objects.equals(this.rotationId(), other.rotationId()) && this.hasNewContactIds() == other.hasNewContactIds() && Objects.equals(this.newContactIds(), other.newContactIds()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRotationOverrideRequest").add("RotationId", (Object)this.rotationId()).add("NewContactIds", this.hasNewContactIds() ? this.newContactIds() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("IdempotencyToken", (Object)this.idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RotationId": {
                return Optional.ofNullable(clazz.cast(this.rotationId()));
            }
            case "NewContactIds": {
                return Optional.ofNullable(clazz.cast(this.newContactIds()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "IdempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateRotationOverrideRequest, T> g) {
        return obj -> g.apply((CreateRotationOverrideRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsRequest.BuilderImpl
    implements Builder {
        private String rotationId;
        private List<String> newContactIds = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRotationOverrideRequest model) {
            super(model);
            this.rotationId(model.rotationId);
            this.newContactIds(model.newContactIds);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.idempotencyToken(model.idempotencyToken);
        }

        public final String getRotationId() {
            return this.rotationId;
        }

        public final void setRotationId(String rotationId) {
            this.rotationId = rotationId;
        }

        @Override
        public final Builder rotationId(String rotationId) {
            this.rotationId = rotationId;
            return this;
        }

        public final Collection<String> getNewContactIds() {
            if (this.newContactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.newContactIds;
        }

        public final void setNewContactIds(Collection<String> newContactIds) {
            this.newContactIds = RotationOverrideContactsArnListCopier.copy(newContactIds);
        }

        @Override
        public final Builder newContactIds(Collection<String> newContactIds) {
            this.newContactIds = RotationOverrideContactsArnListCopier.copy(newContactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newContactIds(String ... newContactIds) {
            this.newContactIds(Arrays.asList(newContactIds));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRotationOverrideRequest build() {
            return new CreateRotationOverrideRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmContactsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRotationOverrideRequest> {
        public Builder rotationId(String var1);

        public Builder newContactIds(Collection<String> var1);

        public Builder newContactIds(String ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder idempotencyToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

