/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.JobResource;
import software.amazon.awssdk.services.snowball.model.JobType;
import software.amazon.awssdk.services.snowball.model.LongTermPricingIdListCopier;
import software.amazon.awssdk.services.snowball.model.Notification;
import software.amazon.awssdk.services.snowball.model.OnDeviceServiceConfiguration;
import software.amazon.awssdk.services.snowball.model.RemoteManagement;
import software.amazon.awssdk.services.snowball.model.ShippingOption;
import software.amazon.awssdk.services.snowball.model.SnowballCapacity;
import software.amazon.awssdk.services.snowball.model.SnowballRequest;
import software.amazon.awssdk.services.snowball.model.SnowballType;
import software.amazon.awssdk.services.snowball.model.TaxDocuments;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends SnowballRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(CreateClusterRequest.getter(CreateClusterRequest::jobTypeAsString)).setter(CreateClusterRequest.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<JobResource> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Resources").getter(CreateClusterRequest.getter(CreateClusterRequest::resources)).setter(CreateClusterRequest.setter(Builder::resources)).constructor(JobResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build()}).build();
    private static final SdkField<OnDeviceServiceConfiguration> ON_DEVICE_SERVICE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnDeviceServiceConfiguration").getter(CreateClusterRequest.getter(CreateClusterRequest::onDeviceServiceConfiguration)).setter(CreateClusterRequest.setter(Builder::onDeviceServiceConfiguration)).constructor(OnDeviceServiceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDeviceServiceConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateClusterRequest.getter(CreateClusterRequest::description)).setter(CreateClusterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressId").getter(CreateClusterRequest.getter(CreateClusterRequest::addressId)).setter(CreateClusterRequest.setter(Builder::addressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressId").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyARN").getter(CreateClusterRequest.getter(CreateClusterRequest::kmsKeyARN)).setter(CreateClusterRequest.setter(Builder::kmsKeyARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyARN").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(CreateClusterRequest.getter(CreateClusterRequest::roleARN)).setter(CreateClusterRequest.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<String> SNOWBALL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnowballType").getter(CreateClusterRequest.getter(CreateClusterRequest::snowballTypeAsString)).setter(CreateClusterRequest.setter(Builder::snowballType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballType").build()}).build();
    private static final SdkField<String> SHIPPING_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ShippingOption").getter(CreateClusterRequest.getter(CreateClusterRequest::shippingOptionAsString)).setter(CreateClusterRequest.setter(Builder::shippingOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingOption").build()}).build();
    private static final SdkField<Notification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Notification").getter(CreateClusterRequest.getter(CreateClusterRequest::notification)).setter(CreateClusterRequest.setter(Builder::notification)).constructor(Notification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notification").build()}).build();
    private static final SdkField<String> FORWARDING_ADDRESS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ForwardingAddressId").getter(CreateClusterRequest.getter(CreateClusterRequest::forwardingAddressId)).setter(CreateClusterRequest.setter(Builder::forwardingAddressId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForwardingAddressId").build()}).build();
    private static final SdkField<TaxDocuments> TAX_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TaxDocuments").getter(CreateClusterRequest.getter(CreateClusterRequest::taxDocuments)).setter(CreateClusterRequest.setter(Builder::taxDocuments)).constructor(TaxDocuments::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaxDocuments").build()}).build();
    private static final SdkField<String> REMOTE_MANAGEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteManagement").getter(CreateClusterRequest.getter(CreateClusterRequest::remoteManagementAsString)).setter(CreateClusterRequest.setter(Builder::remoteManagement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteManagement").build()}).build();
    private static final SdkField<Integer> INITIAL_CLUSTER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InitialClusterSize").getter(CreateClusterRequest.getter(CreateClusterRequest::initialClusterSize)).setter(CreateClusterRequest.setter(Builder::initialClusterSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialClusterSize").build()}).build();
    private static final SdkField<Boolean> FORCE_CREATE_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceCreateJobs").getter(CreateClusterRequest.getter(CreateClusterRequest::forceCreateJobs)).setter(CreateClusterRequest.setter(Builder::forceCreateJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceCreateJobs").build()}).build();
    private static final SdkField<List<String>> LONG_TERM_PRICING_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LongTermPricingIds").getter(CreateClusterRequest.getter(CreateClusterRequest::longTermPricingIds)).setter(CreateClusterRequest.setter(Builder::longTermPricingIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LongTermPricingIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SNOWBALL_CAPACITY_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnowballCapacityPreference").getter(CreateClusterRequest.getter(CreateClusterRequest::snowballCapacityPreferenceAsString)).setter(CreateClusterRequest.setter(Builder::snowballCapacityPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnowballCapacityPreference").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TYPE_FIELD, RESOURCES_FIELD, ON_DEVICE_SERVICE_CONFIGURATION_FIELD, DESCRIPTION_FIELD, ADDRESS_ID_FIELD, KMS_KEY_ARN_FIELD, ROLE_ARN_FIELD, SNOWBALL_TYPE_FIELD, SHIPPING_OPTION_FIELD, NOTIFICATION_FIELD, FORWARDING_ADDRESS_ID_FIELD, TAX_DOCUMENTS_FIELD, REMOTE_MANAGEMENT_FIELD, INITIAL_CLUSTER_SIZE_FIELD, FORCE_CREATE_JOBS_FIELD, LONG_TERM_PRICING_IDS_FIELD, SNOWBALL_CAPACITY_PREFERENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("JobType", JOB_TYPE_FIELD);
            this.put("Resources", RESOURCES_FIELD);
            this.put("OnDeviceServiceConfiguration", ON_DEVICE_SERVICE_CONFIGURATION_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("AddressId", ADDRESS_ID_FIELD);
            this.put("KmsKeyARN", KMS_KEY_ARN_FIELD);
            this.put("RoleARN", ROLE_ARN_FIELD);
            this.put("SnowballType", SNOWBALL_TYPE_FIELD);
            this.put("ShippingOption", SHIPPING_OPTION_FIELD);
            this.put("Notification", NOTIFICATION_FIELD);
            this.put("ForwardingAddressId", FORWARDING_ADDRESS_ID_FIELD);
            this.put("TaxDocuments", TAX_DOCUMENTS_FIELD);
            this.put("RemoteManagement", REMOTE_MANAGEMENT_FIELD);
            this.put("InitialClusterSize", INITIAL_CLUSTER_SIZE_FIELD);
            this.put("ForceCreateJobs", FORCE_CREATE_JOBS_FIELD);
            this.put("LongTermPricingIds", LONG_TERM_PRICING_IDS_FIELD);
            this.put("SnowballCapacityPreference", SNOWBALL_CAPACITY_PREFERENCE_FIELD);
        }
    });
    private final String jobType;
    private final JobResource resources;
    private final OnDeviceServiceConfiguration onDeviceServiceConfiguration;
    private final String description;
    private final String addressId;
    private final String kmsKeyARN;
    private final String roleARN;
    private final String snowballType;
    private final String shippingOption;
    private final Notification notification;
    private final String forwardingAddressId;
    private final TaxDocuments taxDocuments;
    private final String remoteManagement;
    private final Integer initialClusterSize;
    private final Boolean forceCreateJobs;
    private final List<String> longTermPricingIds;
    private final String snowballCapacityPreference;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.jobType = builder.jobType;
        this.resources = builder.resources;
        this.onDeviceServiceConfiguration = builder.onDeviceServiceConfiguration;
        this.description = builder.description;
        this.addressId = builder.addressId;
        this.kmsKeyARN = builder.kmsKeyARN;
        this.roleARN = builder.roleARN;
        this.snowballType = builder.snowballType;
        this.shippingOption = builder.shippingOption;
        this.notification = builder.notification;
        this.forwardingAddressId = builder.forwardingAddressId;
        this.taxDocuments = builder.taxDocuments;
        this.remoteManagement = builder.remoteManagement;
        this.initialClusterSize = builder.initialClusterSize;
        this.forceCreateJobs = builder.forceCreateJobs;
        this.longTermPricingIds = builder.longTermPricingIds;
        this.snowballCapacityPreference = builder.snowballCapacityPreference;
    }

    public final JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final JobResource resources() {
        return this.resources;
    }

    public final OnDeviceServiceConfiguration onDeviceServiceConfiguration() {
        return this.onDeviceServiceConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final String addressId() {
        return this.addressId;
    }

    public final String kmsKeyARN() {
        return this.kmsKeyARN;
    }

    public final String roleARN() {
        return this.roleARN;
    }

    public final SnowballType snowballType() {
        return SnowballType.fromValue(this.snowballType);
    }

    public final String snowballTypeAsString() {
        return this.snowballType;
    }

    public final ShippingOption shippingOption() {
        return ShippingOption.fromValue(this.shippingOption);
    }

    public final String shippingOptionAsString() {
        return this.shippingOption;
    }

    public final Notification notification() {
        return this.notification;
    }

    public final String forwardingAddressId() {
        return this.forwardingAddressId;
    }

    public final TaxDocuments taxDocuments() {
        return this.taxDocuments;
    }

    public final RemoteManagement remoteManagement() {
        return RemoteManagement.fromValue(this.remoteManagement);
    }

    public final String remoteManagementAsString() {
        return this.remoteManagement;
    }

    public final Integer initialClusterSize() {
        return this.initialClusterSize;
    }

    public final Boolean forceCreateJobs() {
        return this.forceCreateJobs;
    }

    public final boolean hasLongTermPricingIds() {
        return this.longTermPricingIds != null && !(this.longTermPricingIds instanceof SdkAutoConstructList);
    }

    public final List<String> longTermPricingIds() {
        return this.longTermPricingIds;
    }

    public final SnowballCapacity snowballCapacityPreference() {
        return SnowballCapacity.fromValue(this.snowballCapacityPreference);
    }

    public final String snowballCapacityPreferenceAsString() {
        return this.snowballCapacityPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resources());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDeviceServiceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardingAddressId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taxDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteManagementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialClusterSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceCreateJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLongTermPricingIds() ? this.longTermPricingIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snowballCapacityPreferenceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.onDeviceServiceConfiguration(), other.onDeviceServiceConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.addressId(), other.addressId()) && Objects.equals(this.kmsKeyARN(), other.kmsKeyARN()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.snowballTypeAsString(), other.snowballTypeAsString()) && Objects.equals(this.shippingOptionAsString(), other.shippingOptionAsString()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.forwardingAddressId(), other.forwardingAddressId()) && Objects.equals(this.taxDocuments(), other.taxDocuments()) && Objects.equals(this.remoteManagementAsString(), other.remoteManagementAsString()) && Objects.equals(this.initialClusterSize(), other.initialClusterSize()) && Objects.equals(this.forceCreateJobs(), other.forceCreateJobs()) && this.hasLongTermPricingIds() == other.hasLongTermPricingIds() && Objects.equals(this.longTermPricingIds(), other.longTermPricingIds()) && Objects.equals(this.snowballCapacityPreferenceAsString(), other.snowballCapacityPreferenceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("JobType", (Object)this.jobTypeAsString()).add("Resources", (Object)this.resources()).add("OnDeviceServiceConfiguration", (Object)this.onDeviceServiceConfiguration()).add("Description", (Object)this.description()).add("AddressId", (Object)this.addressId()).add("KmsKeyARN", (Object)this.kmsKeyARN()).add("RoleARN", (Object)this.roleARN()).add("SnowballType", (Object)this.snowballTypeAsString()).add("ShippingOption", (Object)this.shippingOptionAsString()).add("Notification", (Object)this.notification()).add("ForwardingAddressId", (Object)this.forwardingAddressId()).add("TaxDocuments", (Object)this.taxDocuments()).add("RemoteManagement", (Object)this.remoteManagementAsString()).add("InitialClusterSize", (Object)this.initialClusterSize()).add("ForceCreateJobs", (Object)this.forceCreateJobs()).add("LongTermPricingIds", this.hasLongTermPricingIds() ? this.longTermPricingIds() : null).add("SnowballCapacityPreference", (Object)this.snowballCapacityPreferenceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "OnDeviceServiceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.onDeviceServiceConfiguration()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AddressId": {
                return Optional.ofNullable(clazz.cast(this.addressId()));
            }
            case "KmsKeyARN": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyARN()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "SnowballType": {
                return Optional.ofNullable(clazz.cast(this.snowballTypeAsString()));
            }
            case "ShippingOption": {
                return Optional.ofNullable(clazz.cast(this.shippingOptionAsString()));
            }
            case "Notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "ForwardingAddressId": {
                return Optional.ofNullable(clazz.cast(this.forwardingAddressId()));
            }
            case "TaxDocuments": {
                return Optional.ofNullable(clazz.cast(this.taxDocuments()));
            }
            case "RemoteManagement": {
                return Optional.ofNullable(clazz.cast(this.remoteManagementAsString()));
            }
            case "InitialClusterSize": {
                return Optional.ofNullable(clazz.cast(this.initialClusterSize()));
            }
            case "ForceCreateJobs": {
                return Optional.ofNullable(clazz.cast(this.forceCreateJobs()));
            }
            case "LongTermPricingIds": {
                return Optional.ofNullable(clazz.cast(this.longTermPricingIds()));
            }
            case "SnowballCapacityPreference": {
                return Optional.ofNullable(clazz.cast(this.snowballCapacityPreferenceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballRequest.BuilderImpl
    implements Builder {
        private String jobType;
        private JobResource resources;
        private OnDeviceServiceConfiguration onDeviceServiceConfiguration;
        private String description;
        private String addressId;
        private String kmsKeyARN;
        private String roleARN;
        private String snowballType;
        private String shippingOption;
        private Notification notification;
        private String forwardingAddressId;
        private TaxDocuments taxDocuments;
        private String remoteManagement;
        private Integer initialClusterSize;
        private Boolean forceCreateJobs;
        private List<String> longTermPricingIds = DefaultSdkAutoConstructList.getInstance();
        private String snowballCapacityPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.jobType(model.jobType);
            this.resources(model.resources);
            this.onDeviceServiceConfiguration(model.onDeviceServiceConfiguration);
            this.description(model.description);
            this.addressId(model.addressId);
            this.kmsKeyARN(model.kmsKeyARN);
            this.roleARN(model.roleARN);
            this.snowballType(model.snowballType);
            this.shippingOption(model.shippingOption);
            this.notification(model.notification);
            this.forwardingAddressId(model.forwardingAddressId);
            this.taxDocuments(model.taxDocuments);
            this.remoteManagement(model.remoteManagement);
            this.initialClusterSize(model.initialClusterSize);
            this.forceCreateJobs(model.forceCreateJobs);
            this.longTermPricingIds(model.longTermPricingIds);
            this.snowballCapacityPreference(model.snowballCapacityPreference);
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final JobResource.Builder getResources() {
            return this.resources != null ? this.resources.toBuilder() : null;
        }

        public final void setResources(JobResource.BuilderImpl resources) {
            this.resources = resources != null ? resources.build() : null;
        }

        @Override
        public final Builder resources(JobResource resources) {
            this.resources = resources;
            return this;
        }

        public final OnDeviceServiceConfiguration.Builder getOnDeviceServiceConfiguration() {
            return this.onDeviceServiceConfiguration != null ? this.onDeviceServiceConfiguration.toBuilder() : null;
        }

        public final void setOnDeviceServiceConfiguration(OnDeviceServiceConfiguration.BuilderImpl onDeviceServiceConfiguration) {
            this.onDeviceServiceConfiguration = onDeviceServiceConfiguration != null ? onDeviceServiceConfiguration.build() : null;
        }

        @Override
        public final Builder onDeviceServiceConfiguration(OnDeviceServiceConfiguration onDeviceServiceConfiguration) {
            this.onDeviceServiceConfiguration = onDeviceServiceConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getAddressId() {
            return this.addressId;
        }

        public final void setAddressId(String addressId) {
            this.addressId = addressId;
        }

        @Override
        public final Builder addressId(String addressId) {
            this.addressId = addressId;
            return this;
        }

        public final String getKmsKeyARN() {
            return this.kmsKeyARN;
        }

        public final void setKmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
        }

        @Override
        public final Builder kmsKeyARN(String kmsKeyARN) {
            this.kmsKeyARN = kmsKeyARN;
            return this;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final String getSnowballType() {
            return this.snowballType;
        }

        public final void setSnowballType(String snowballType) {
            this.snowballType = snowballType;
        }

        @Override
        public final Builder snowballType(String snowballType) {
            this.snowballType = snowballType;
            return this;
        }

        @Override
        public final Builder snowballType(SnowballType snowballType) {
            this.snowballType(snowballType == null ? null : snowballType.toString());
            return this;
        }

        public final String getShippingOption() {
            return this.shippingOption;
        }

        public final void setShippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
        }

        @Override
        public final Builder shippingOption(String shippingOption) {
            this.shippingOption = shippingOption;
            return this;
        }

        @Override
        public final Builder shippingOption(ShippingOption shippingOption) {
            this.shippingOption(shippingOption == null ? null : shippingOption.toString());
            return this;
        }

        public final Notification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        public final void setNotification(Notification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        public final Builder notification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public final String getForwardingAddressId() {
            return this.forwardingAddressId;
        }

        public final void setForwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
        }

        @Override
        public final Builder forwardingAddressId(String forwardingAddressId) {
            this.forwardingAddressId = forwardingAddressId;
            return this;
        }

        public final TaxDocuments.Builder getTaxDocuments() {
            return this.taxDocuments != null ? this.taxDocuments.toBuilder() : null;
        }

        public final void setTaxDocuments(TaxDocuments.BuilderImpl taxDocuments) {
            this.taxDocuments = taxDocuments != null ? taxDocuments.build() : null;
        }

        @Override
        public final Builder taxDocuments(TaxDocuments taxDocuments) {
            this.taxDocuments = taxDocuments;
            return this;
        }

        public final String getRemoteManagement() {
            return this.remoteManagement;
        }

        public final void setRemoteManagement(String remoteManagement) {
            this.remoteManagement = remoteManagement;
        }

        @Override
        public final Builder remoteManagement(String remoteManagement) {
            this.remoteManagement = remoteManagement;
            return this;
        }

        @Override
        public final Builder remoteManagement(RemoteManagement remoteManagement) {
            this.remoteManagement(remoteManagement == null ? null : remoteManagement.toString());
            return this;
        }

        public final Integer getInitialClusterSize() {
            return this.initialClusterSize;
        }

        public final void setInitialClusterSize(Integer initialClusterSize) {
            this.initialClusterSize = initialClusterSize;
        }

        @Override
        public final Builder initialClusterSize(Integer initialClusterSize) {
            this.initialClusterSize = initialClusterSize;
            return this;
        }

        public final Boolean getForceCreateJobs() {
            return this.forceCreateJobs;
        }

        public final void setForceCreateJobs(Boolean forceCreateJobs) {
            this.forceCreateJobs = forceCreateJobs;
        }

        @Override
        public final Builder forceCreateJobs(Boolean forceCreateJobs) {
            this.forceCreateJobs = forceCreateJobs;
            return this;
        }

        public final Collection<String> getLongTermPricingIds() {
            if (this.longTermPricingIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.longTermPricingIds;
        }

        public final void setLongTermPricingIds(Collection<String> longTermPricingIds) {
            this.longTermPricingIds = LongTermPricingIdListCopier.copy(longTermPricingIds);
        }

        @Override
        public final Builder longTermPricingIds(Collection<String> longTermPricingIds) {
            this.longTermPricingIds = LongTermPricingIdListCopier.copy(longTermPricingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder longTermPricingIds(String ... longTermPricingIds) {
            this.longTermPricingIds(Arrays.asList(longTermPricingIds));
            return this;
        }

        public final String getSnowballCapacityPreference() {
            return this.snowballCapacityPreference;
        }

        public final void setSnowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
        }

        @Override
        public final Builder snowballCapacityPreference(String snowballCapacityPreference) {
            this.snowballCapacityPreference = snowballCapacityPreference;
            return this;
        }

        @Override
        public final Builder snowballCapacityPreference(SnowballCapacity snowballCapacityPreference) {
            this.snowballCapacityPreference(snowballCapacityPreference == null ? null : snowballCapacityPreference.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SnowballRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder jobType(String var1);

        public Builder jobType(JobType var1);

        public Builder resources(JobResource var1);

        default public Builder resources(Consumer<JobResource.Builder> resources) {
            return this.resources((JobResource)((JobResource.Builder)JobResource.builder().applyMutation(resources)).build());
        }

        public Builder onDeviceServiceConfiguration(OnDeviceServiceConfiguration var1);

        default public Builder onDeviceServiceConfiguration(Consumer<OnDeviceServiceConfiguration.Builder> onDeviceServiceConfiguration) {
            return this.onDeviceServiceConfiguration((OnDeviceServiceConfiguration)((OnDeviceServiceConfiguration.Builder)OnDeviceServiceConfiguration.builder().applyMutation(onDeviceServiceConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder addressId(String var1);

        public Builder kmsKeyARN(String var1);

        public Builder roleARN(String var1);

        public Builder snowballType(String var1);

        public Builder snowballType(SnowballType var1);

        public Builder shippingOption(String var1);

        public Builder shippingOption(ShippingOption var1);

        public Builder notification(Notification var1);

        default public Builder notification(Consumer<Notification.Builder> notification) {
            return this.notification((Notification)((Notification.Builder)Notification.builder().applyMutation(notification)).build());
        }

        public Builder forwardingAddressId(String var1);

        public Builder taxDocuments(TaxDocuments var1);

        default public Builder taxDocuments(Consumer<TaxDocuments.Builder> taxDocuments) {
            return this.taxDocuments((TaxDocuments)((TaxDocuments.Builder)TaxDocuments.builder().applyMutation(taxDocuments)).build());
        }

        public Builder remoteManagement(String var1);

        public Builder remoteManagement(RemoteManagement var1);

        public Builder initialClusterSize(Integer var1);

        public Builder forceCreateJobs(Boolean var1);

        public Builder longTermPricingIds(Collection<String> var1);

        public Builder longTermPricingIds(String ... var1);

        public Builder snowballCapacityPreference(String var1);

        public Builder snowballCapacityPreference(SnowballCapacity var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

