/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.ExportDataSource;
import software.amazon.awssdk.services.sesv2.model.ExportDestination;
import software.amazon.awssdk.services.sesv2.model.ExportSourceType;
import software.amazon.awssdk.services.sesv2.model.ExportStatistics;
import software.amazon.awssdk.services.sesv2.model.FailureInfo;
import software.amazon.awssdk.services.sesv2.model.JobStatus;
import software.amazon.awssdk.services.sesv2.model.SesV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExportJobResponse
extends SesV2Response
implements ToCopyableBuilder<Builder, GetExportJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobId").getter(GetExportJobResponse.getter(GetExportJobResponse::jobId)).setter(GetExportJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()}).build();
    private static final SdkField<String> EXPORT_SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportSourceType").getter(GetExportJobResponse.getter(GetExportJobResponse::exportSourceTypeAsString)).setter(GetExportJobResponse.setter(Builder::exportSourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportSourceType").build()}).build();
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(GetExportJobResponse.getter(GetExportJobResponse::jobStatusAsString)).setter(GetExportJobResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<ExportDestination> EXPORT_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportDestination").getter(GetExportJobResponse.getter(GetExportJobResponse::exportDestination)).setter(GetExportJobResponse.setter(Builder::exportDestination)).constructor(ExportDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDestination").build()}).build();
    private static final SdkField<ExportDataSource> EXPORT_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportDataSource").getter(GetExportJobResponse.getter(GetExportJobResponse::exportDataSource)).setter(GetExportJobResponse.setter(Builder::exportDataSource)).constructor(ExportDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportDataSource").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(GetExportJobResponse.getter(GetExportJobResponse::createdTimestamp)).setter(GetExportJobResponse.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> COMPLETED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedTimestamp").getter(GetExportJobResponse.getter(GetExportJobResponse::completedTimestamp)).setter(GetExportJobResponse.setter(Builder::completedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedTimestamp").build()}).build();
    private static final SdkField<FailureInfo> FAILURE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureInfo").getter(GetExportJobResponse.getter(GetExportJobResponse::failureInfo)).setter(GetExportJobResponse.setter(Builder::failureInfo)).constructor(FailureInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureInfo").build()}).build();
    private static final SdkField<ExportStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Statistics").getter(GetExportJobResponse.getter(GetExportJobResponse::statistics)).setter(GetExportJobResponse.setter(Builder::statistics)).constructor(ExportStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, EXPORT_SOURCE_TYPE_FIELD, JOB_STATUS_FIELD, EXPORT_DESTINATION_FIELD, EXPORT_DATA_SOURCE_FIELD, CREATED_TIMESTAMP_FIELD, COMPLETED_TIMESTAMP_FIELD, FAILURE_INFO_FIELD, STATISTICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("JobId", JOB_ID_FIELD);
            this.put("ExportSourceType", EXPORT_SOURCE_TYPE_FIELD);
            this.put("JobStatus", JOB_STATUS_FIELD);
            this.put("ExportDestination", EXPORT_DESTINATION_FIELD);
            this.put("ExportDataSource", EXPORT_DATA_SOURCE_FIELD);
            this.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
            this.put("CompletedTimestamp", COMPLETED_TIMESTAMP_FIELD);
            this.put("FailureInfo", FAILURE_INFO_FIELD);
            this.put("Statistics", STATISTICS_FIELD);
        }
    });
    private final String jobId;
    private final String exportSourceType;
    private final String jobStatus;
    private final ExportDestination exportDestination;
    private final ExportDataSource exportDataSource;
    private final Instant createdTimestamp;
    private final Instant completedTimestamp;
    private final FailureInfo failureInfo;
    private final ExportStatistics statistics;

    private GetExportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.exportSourceType = builder.exportSourceType;
        this.jobStatus = builder.jobStatus;
        this.exportDestination = builder.exportDestination;
        this.exportDataSource = builder.exportDataSource;
        this.createdTimestamp = builder.createdTimestamp;
        this.completedTimestamp = builder.completedTimestamp;
        this.failureInfo = builder.failureInfo;
        this.statistics = builder.statistics;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final ExportSourceType exportSourceType() {
        return ExportSourceType.fromValue(this.exportSourceType);
    }

    public final String exportSourceTypeAsString() {
        return this.exportSourceType;
    }

    public final JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public final String jobStatusAsString() {
        return this.jobStatus;
    }

    public final ExportDestination exportDestination() {
        return this.exportDestination;
    }

    public final ExportDataSource exportDataSource() {
        return this.exportDataSource;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant completedTimestamp() {
        return this.completedTimestamp;
    }

    public final FailureInfo failureInfo() {
        return this.failureInfo;
    }

    public final ExportStatistics statistics() {
        return this.statistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportSourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExportJobResponse)) {
            return false;
        }
        GetExportJobResponse other = (GetExportJobResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.exportSourceTypeAsString(), other.exportSourceTypeAsString()) && Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.exportDestination(), other.exportDestination()) && Objects.equals(this.exportDataSource(), other.exportDataSource()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.completedTimestamp(), other.completedTimestamp()) && Objects.equals(this.failureInfo(), other.failureInfo()) && Objects.equals(this.statistics(), other.statistics());
    }

    public final String toString() {
        return ToString.builder((String)"GetExportJobResponse").add("JobId", (Object)this.jobId()).add("ExportSourceType", (Object)this.exportSourceTypeAsString()).add("JobStatus", (Object)this.jobStatusAsString()).add("ExportDestination", (Object)this.exportDestination()).add("ExportDataSource", (Object)this.exportDataSource()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("CompletedTimestamp", (Object)this.completedTimestamp()).add("FailureInfo", (Object)this.failureInfo()).add("Statistics", (Object)this.statistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "ExportSourceType": {
                return Optional.ofNullable(clazz.cast(this.exportSourceTypeAsString()));
            }
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "ExportDestination": {
                return Optional.ofNullable(clazz.cast(this.exportDestination()));
            }
            case "ExportDataSource": {
                return Optional.ofNullable(clazz.cast(this.exportDataSource()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "CompletedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.completedTimestamp()));
            }
            case "FailureInfo": {
                return Optional.ofNullable(clazz.cast(this.failureInfo()));
            }
            case "Statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetExportJobResponse, T> g) {
        return obj -> g.apply((GetExportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesV2Response.BuilderImpl
    implements Builder {
        private String jobId;
        private String exportSourceType;
        private String jobStatus;
        private ExportDestination exportDestination;
        private ExportDataSource exportDataSource;
        private Instant createdTimestamp;
        private Instant completedTimestamp;
        private FailureInfo failureInfo;
        private ExportStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExportJobResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.exportSourceType(model.exportSourceType);
            this.jobStatus(model.jobStatus);
            this.exportDestination(model.exportDestination);
            this.exportDataSource(model.exportDataSource);
            this.createdTimestamp(model.createdTimestamp);
            this.completedTimestamp(model.completedTimestamp);
            this.failureInfo(model.failureInfo);
            this.statistics(model.statistics);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getExportSourceType() {
            return this.exportSourceType;
        }

        public final void setExportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
        }

        @Override
        public final Builder exportSourceType(String exportSourceType) {
            this.exportSourceType = exportSourceType;
            return this;
        }

        @Override
        public final Builder exportSourceType(ExportSourceType exportSourceType) {
            this.exportSourceType(exportSourceType == null ? null : exportSourceType.toString());
            return this;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final ExportDestination.Builder getExportDestination() {
            return this.exportDestination != null ? this.exportDestination.toBuilder() : null;
        }

        public final void setExportDestination(ExportDestination.BuilderImpl exportDestination) {
            this.exportDestination = exportDestination != null ? exportDestination.build() : null;
        }

        @Override
        public final Builder exportDestination(ExportDestination exportDestination) {
            this.exportDestination = exportDestination;
            return this;
        }

        public final ExportDataSource.Builder getExportDataSource() {
            return this.exportDataSource != null ? this.exportDataSource.toBuilder() : null;
        }

        public final void setExportDataSource(ExportDataSource.BuilderImpl exportDataSource) {
            this.exportDataSource = exportDataSource != null ? exportDataSource.build() : null;
        }

        @Override
        public final Builder exportDataSource(ExportDataSource exportDataSource) {
            this.exportDataSource = exportDataSource;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getCompletedTimestamp() {
            return this.completedTimestamp;
        }

        public final void setCompletedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        public final FailureInfo.Builder getFailureInfo() {
            return this.failureInfo != null ? this.failureInfo.toBuilder() : null;
        }

        public final void setFailureInfo(FailureInfo.BuilderImpl failureInfo) {
            this.failureInfo = failureInfo != null ? failureInfo.build() : null;
        }

        @Override
        public final Builder failureInfo(FailureInfo failureInfo) {
            this.failureInfo = failureInfo;
            return this;
        }

        public final ExportStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(ExportStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(ExportStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        @Override
        public GetExportJobResponse build() {
            return new GetExportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SesV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExportJobResponse> {
        public Builder jobId(String var1);

        public Builder exportSourceType(String var1);

        public Builder exportSourceType(ExportSourceType var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder exportDestination(ExportDestination var1);

        default public Builder exportDestination(Consumer<ExportDestination.Builder> exportDestination) {
            return this.exportDestination((ExportDestination)((ExportDestination.Builder)ExportDestination.builder().applyMutation(exportDestination)).build());
        }

        public Builder exportDataSource(ExportDataSource var1);

        default public Builder exportDataSource(Consumer<ExportDataSource.Builder> exportDataSource) {
            return this.exportDataSource((ExportDataSource)((ExportDataSource.Builder)ExportDataSource.builder().applyMutation(exportDataSource)).build());
        }

        public Builder createdTimestamp(Instant var1);

        public Builder completedTimestamp(Instant var1);

        public Builder failureInfo(FailureInfo var1);

        default public Builder failureInfo(Consumer<FailureInfo.Builder> failureInfo) {
            return this.failureInfo((FailureInfo)((FailureInfo.Builder)FailureInfo.builder().applyMutation(failureInfo)).build());
        }

        public Builder statistics(ExportStatistics var1);

        default public Builder statistics(Consumer<ExportStatistics.Builder> statistics) {
            return this.statistics((ExportStatistics)((ExportStatistics.Builder)ExportStatistics.builder().applyMutation(statistics)).build());
        }
    }
}

