/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsAsAdminResponse;

public class SearchProductsAsAdminIterable
implements SdkIterable<SearchProductsAsAdminResponse> {
    private final ServiceCatalogClient client;
    private final SearchProductsAsAdminRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchProductsAsAdminIterable(ServiceCatalogClient client, SearchProductsAsAdminRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchProductsAsAdminResponseFetcher();
    }

    public Iterator<SearchProductsAsAdminResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchProductsAsAdminResponseFetcher
    implements SyncPageFetcher<SearchProductsAsAdminResponse> {
        private SearchProductsAsAdminResponseFetcher() {
        }

        public boolean hasNextPage(SearchProductsAsAdminResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public SearchProductsAsAdminResponse nextPage(SearchProductsAsAdminResponse previousPage) {
            if (previousPage == null) {
                return SearchProductsAsAdminIterable.this.client.searchProductsAsAdmin(SearchProductsAsAdminIterable.this.firstRequest);
            }
            return SearchProductsAsAdminIterable.this.client.searchProductsAsAdmin((SearchProductsAsAdminRequest)((Object)SearchProductsAsAdminIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

