/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.services.servicecatalog.model.StackInstance;
import software.amazon.awssdk.services.servicecatalog.model.StackInstancesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStackInstancesForProvisionedProductResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListStackInstancesForProvisionedProductResponse> {
    private static final SdkField<List<StackInstance>> STACK_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackInstances").getter(ListStackInstancesForProvisionedProductResponse.getter(ListStackInstancesForProvisionedProductResponse::stackInstances)).setter(ListStackInstancesForProvisionedProductResponse.setter(Builder::stackInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StackInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListStackInstancesForProvisionedProductResponse.getter(ListStackInstancesForProvisionedProductResponse::nextPageToken)).setter(ListStackInstancesForProvisionedProductResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_INSTANCES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StackInstances", STACK_INSTANCES_FIELD);
            this.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        }
    });
    private final List<StackInstance> stackInstances;
    private final String nextPageToken;

    private ListStackInstancesForProvisionedProductResponse(BuilderImpl builder) {
        super(builder);
        this.stackInstances = builder.stackInstances;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasStackInstances() {
        return this.stackInstances != null && !(this.stackInstances instanceof SdkAutoConstructList);
    }

    public final List<StackInstance> stackInstances() {
        return this.stackInstances;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackInstances() ? this.stackInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackInstancesForProvisionedProductResponse)) {
            return false;
        }
        ListStackInstancesForProvisionedProductResponse other = (ListStackInstancesForProvisionedProductResponse)((Object)obj);
        return this.hasStackInstances() == other.hasStackInstances() && Objects.equals(this.stackInstances(), other.stackInstances()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStackInstancesForProvisionedProductResponse").add("StackInstances", this.hasStackInstances() ? this.stackInstances() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackInstances": {
                return Optional.ofNullable(clazz.cast(this.stackInstances()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListStackInstancesForProvisionedProductResponse, T> g) {
        return obj -> g.apply((ListStackInstancesForProvisionedProductResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<StackInstance> stackInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackInstancesForProvisionedProductResponse model) {
            super(model);
            this.stackInstances(model.stackInstances);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<StackInstance.Builder> getStackInstances() {
            List<StackInstance.Builder> result = StackInstancesCopier.copyToBuilder(this.stackInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackInstances(Collection<StackInstance.BuilderImpl> stackInstances) {
            this.stackInstances = StackInstancesCopier.copyFromBuilder(stackInstances);
        }

        @Override
        public final Builder stackInstances(Collection<StackInstance> stackInstances) {
            this.stackInstances = StackInstancesCopier.copy(stackInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackInstances(StackInstance ... stackInstances) {
            this.stackInstances(Arrays.asList(stackInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackInstances(Consumer<StackInstance.Builder> ... stackInstances) {
            this.stackInstances(Stream.of(stackInstances).map(c -> (StackInstance)((StackInstance.Builder)StackInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListStackInstancesForProvisionedProductResponse build() {
            return new ListStackInstancesForProvisionedProductResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStackInstancesForProvisionedProductResponse> {
        public Builder stackInstances(Collection<StackInstance> var1);

        public Builder stackInstances(StackInstance ... var1);

        public Builder stackInstances(Consumer<StackInstance.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

