/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securitylake.model.AwsLogSourceName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsLogSourceResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsLogSourceResource> {
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceName").getter(AwsLogSourceResource.getter(AwsLogSourceResource::sourceNameAsString)).setter(AwsLogSourceResource.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVersion").getter(AwsLogSourceResource.getter(AwsLogSourceResource::sourceVersion)).setter(AwsLogSourceResource.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_NAME_FIELD, SOURCE_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sourceName", SOURCE_NAME_FIELD);
            this.put("sourceVersion", SOURCE_VERSION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sourceName;
    private final String sourceVersion;

    private AwsLogSourceResource(BuilderImpl builder) {
        this.sourceName = builder.sourceName;
        this.sourceVersion = builder.sourceVersion;
    }

    public final AwsLogSourceName sourceName() {
        return AwsLogSourceName.fromValue(this.sourceName);
    }

    public final String sourceNameAsString() {
        return this.sourceName;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLogSourceResource)) {
            return false;
        }
        AwsLogSourceResource other = (AwsLogSourceResource)obj;
        return Objects.equals(this.sourceNameAsString(), other.sourceNameAsString()) && Objects.equals(this.sourceVersion(), other.sourceVersion());
    }

    public final String toString() {
        return ToString.builder((String)"AwsLogSourceResource").add("SourceName", (Object)this.sourceNameAsString()).add("SourceVersion", (Object)this.sourceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceNameAsString()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsLogSourceResource, T> g) {
        return obj -> g.apply((AwsLogSourceResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceName;
        private String sourceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLogSourceResource model) {
            this.sourceName(model.sourceName);
            this.sourceVersion(model.sourceVersion);
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        @Override
        public final Builder sourceName(AwsLogSourceName sourceName) {
            this.sourceName(sourceName == null ? null : sourceName.toString());
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public AwsLogSourceResource build() {
            return new AwsLogSourceResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsLogSourceResource> {
        public Builder sourceName(String var1);

        public Builder sourceName(AwsLogSourceName var1);

        public Builder sourceVersion(String var1);
    }
}

