/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsResponse;

public class ListConfigurationPolicyAssociationsIterable
implements SdkIterable<ListConfigurationPolicyAssociationsResponse> {
    private final SecurityHubClient client;
    private final ListConfigurationPolicyAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationPolicyAssociationsIterable(SecurityHubClient client, ListConfigurationPolicyAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfigurationPolicyAssociationsResponseFetcher();
    }

    public Iterator<ListConfigurationPolicyAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationPolicyAssociationSummary> configurationPolicyAssociationSummaries() {
        Function<ListConfigurationPolicyAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationPolicyAssociationSummaries() != null) {
                return response.configurationPolicyAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfigurationPolicyAssociationsResponseFetcher
    implements SyncPageFetcher<ListConfigurationPolicyAssociationsResponse> {
        private ListConfigurationPolicyAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationPolicyAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationPolicyAssociationsResponse nextPage(ListConfigurationPolicyAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationPolicyAssociationsIterable.this.client.listConfigurationPolicyAssociations(ListConfigurationPolicyAssociationsIterable.this.firstRequest);
            }
            return ListConfigurationPolicyAssociationsIterable.this.client.listConfigurationPolicyAssociations((ListConfigurationPolicyAssociationsRequest)((Object)ListConfigurationPolicyAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

