/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationListCopier;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.UnprocessedConfigurationPolicyAssociation;
import software.amazon.awssdk.services.securityhub.model.UnprocessedConfigurationPolicyAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetConfigurationPolicyAssociationsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, BatchGetConfigurationPolicyAssociationsResponse> {
    private static final SdkField<List<ConfigurationPolicyAssociationSummary>> CONFIGURATION_POLICY_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationPolicyAssociations").getter(BatchGetConfigurationPolicyAssociationsResponse.getter(BatchGetConfigurationPolicyAssociationsResponse::configurationPolicyAssociations)).setter(BatchGetConfigurationPolicyAssociationsResponse.setter(Builder::configurationPolicyAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicyAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationPolicyAssociationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedConfigurationPolicyAssociation>> UNPROCESSED_CONFIGURATION_POLICY_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedConfigurationPolicyAssociations").getter(BatchGetConfigurationPolicyAssociationsResponse.getter(BatchGetConfigurationPolicyAssociationsResponse::unprocessedConfigurationPolicyAssociations)).setter(BatchGetConfigurationPolicyAssociationsResponse.setter(Builder::unprocessedConfigurationPolicyAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedConfigurationPolicyAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedConfigurationPolicyAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_POLICY_ASSOCIATIONS_FIELD, UNPROCESSED_CONFIGURATION_POLICY_ASSOCIATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfigurationPolicyAssociations", CONFIGURATION_POLICY_ASSOCIATIONS_FIELD);
            this.put("UnprocessedConfigurationPolicyAssociations", UNPROCESSED_CONFIGURATION_POLICY_ASSOCIATIONS_FIELD);
        }
    });
    private final List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociations;
    private final List<UnprocessedConfigurationPolicyAssociation> unprocessedConfigurationPolicyAssociations;

    private BatchGetConfigurationPolicyAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationPolicyAssociations = builder.configurationPolicyAssociations;
        this.unprocessedConfigurationPolicyAssociations = builder.unprocessedConfigurationPolicyAssociations;
    }

    public final boolean hasConfigurationPolicyAssociations() {
        return this.configurationPolicyAssociations != null && !(this.configurationPolicyAssociations instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociations() {
        return this.configurationPolicyAssociations;
    }

    public final boolean hasUnprocessedConfigurationPolicyAssociations() {
        return this.unprocessedConfigurationPolicyAssociations != null && !(this.unprocessedConfigurationPolicyAssociations instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedConfigurationPolicyAssociation> unprocessedConfigurationPolicyAssociations() {
        return this.unprocessedConfigurationPolicyAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationPolicyAssociations() ? this.configurationPolicyAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedConfigurationPolicyAssociations() ? this.unprocessedConfigurationPolicyAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetConfigurationPolicyAssociationsResponse)) {
            return false;
        }
        BatchGetConfigurationPolicyAssociationsResponse other = (BatchGetConfigurationPolicyAssociationsResponse)((Object)obj);
        return this.hasConfigurationPolicyAssociations() == other.hasConfigurationPolicyAssociations() && Objects.equals(this.configurationPolicyAssociations(), other.configurationPolicyAssociations()) && this.hasUnprocessedConfigurationPolicyAssociations() == other.hasUnprocessedConfigurationPolicyAssociations() && Objects.equals(this.unprocessedConfigurationPolicyAssociations(), other.unprocessedConfigurationPolicyAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetConfigurationPolicyAssociationsResponse").add("ConfigurationPolicyAssociations", this.hasConfigurationPolicyAssociations() ? this.configurationPolicyAssociations() : null).add("UnprocessedConfigurationPolicyAssociations", this.hasUnprocessedConfigurationPolicyAssociations() ? this.unprocessedConfigurationPolicyAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationPolicyAssociations": {
                return Optional.ofNullable(clazz.cast(this.configurationPolicyAssociations()));
            }
            case "UnprocessedConfigurationPolicyAssociations": {
                return Optional.ofNullable(clazz.cast(this.unprocessedConfigurationPolicyAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetConfigurationPolicyAssociationsResponse, T> g) {
        return obj -> g.apply((BatchGetConfigurationPolicyAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationPolicyAssociationSummary> configurationPolicyAssociations = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedConfigurationPolicyAssociation> unprocessedConfigurationPolicyAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetConfigurationPolicyAssociationsResponse model) {
            super(model);
            this.configurationPolicyAssociations(model.configurationPolicyAssociations);
            this.unprocessedConfigurationPolicyAssociations(model.unprocessedConfigurationPolicyAssociations);
        }

        public final List<ConfigurationPolicyAssociationSummary.Builder> getConfigurationPolicyAssociations() {
            List<ConfigurationPolicyAssociationSummary.Builder> result = ConfigurationPolicyAssociationListCopier.copyToBuilder(this.configurationPolicyAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationPolicyAssociations(Collection<ConfigurationPolicyAssociationSummary.BuilderImpl> configurationPolicyAssociations) {
            this.configurationPolicyAssociations = ConfigurationPolicyAssociationListCopier.copyFromBuilder(configurationPolicyAssociations);
        }

        @Override
        public final Builder configurationPolicyAssociations(Collection<ConfigurationPolicyAssociationSummary> configurationPolicyAssociations) {
            this.configurationPolicyAssociations = ConfigurationPolicyAssociationListCopier.copy(configurationPolicyAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicyAssociations(ConfigurationPolicyAssociationSummary ... configurationPolicyAssociations) {
            this.configurationPolicyAssociations(Arrays.asList(configurationPolicyAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationPolicyAssociations(Consumer<ConfigurationPolicyAssociationSummary.Builder> ... configurationPolicyAssociations) {
            this.configurationPolicyAssociations(Stream.of(configurationPolicyAssociations).map(c -> (ConfigurationPolicyAssociationSummary)((ConfigurationPolicyAssociationSummary.Builder)ConfigurationPolicyAssociationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedConfigurationPolicyAssociation.Builder> getUnprocessedConfigurationPolicyAssociations() {
            List<UnprocessedConfigurationPolicyAssociation.Builder> result = UnprocessedConfigurationPolicyAssociationListCopier.copyToBuilder(this.unprocessedConfigurationPolicyAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedConfigurationPolicyAssociations(Collection<UnprocessedConfigurationPolicyAssociation.BuilderImpl> unprocessedConfigurationPolicyAssociations) {
            this.unprocessedConfigurationPolicyAssociations = UnprocessedConfigurationPolicyAssociationListCopier.copyFromBuilder(unprocessedConfigurationPolicyAssociations);
        }

        @Override
        public final Builder unprocessedConfigurationPolicyAssociations(Collection<UnprocessedConfigurationPolicyAssociation> unprocessedConfigurationPolicyAssociations) {
            this.unprocessedConfigurationPolicyAssociations = UnprocessedConfigurationPolicyAssociationListCopier.copy(unprocessedConfigurationPolicyAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedConfigurationPolicyAssociations(UnprocessedConfigurationPolicyAssociation ... unprocessedConfigurationPolicyAssociations) {
            this.unprocessedConfigurationPolicyAssociations(Arrays.asList(unprocessedConfigurationPolicyAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedConfigurationPolicyAssociations(Consumer<UnprocessedConfigurationPolicyAssociation.Builder> ... unprocessedConfigurationPolicyAssociations) {
            this.unprocessedConfigurationPolicyAssociations(Stream.of(unprocessedConfigurationPolicyAssociations).map(c -> (UnprocessedConfigurationPolicyAssociation)((UnprocessedConfigurationPolicyAssociation.Builder)UnprocessedConfigurationPolicyAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetConfigurationPolicyAssociationsResponse build() {
            return new BatchGetConfigurationPolicyAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetConfigurationPolicyAssociationsResponse> {
        public Builder configurationPolicyAssociations(Collection<ConfigurationPolicyAssociationSummary> var1);

        public Builder configurationPolicyAssociations(ConfigurationPolicyAssociationSummary ... var1);

        public Builder configurationPolicyAssociations(Consumer<ConfigurationPolicyAssociationSummary.Builder> ... var1);

        public Builder unprocessedConfigurationPolicyAssociations(Collection<UnprocessedConfigurationPolicyAssociation> var1);

        public Builder unprocessedConfigurationPolicyAssociations(UnprocessedConfigurationPolicyAssociation ... var1);

        public Builder unprocessedConfigurationPolicyAssociations(Consumer<UnprocessedConfigurationPolicyAssociation.Builder> ... var1);
    }
}

