/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.AwsApiGatewayAccessLogSettings;
import software.amazon.awssdk.services.securityhub.model.AwsApiGatewayV2RouteSettings;
import software.amazon.awssdk.services.securityhub.model.FieldMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsApiGatewayV2StageDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsApiGatewayV2StageDetails> {
    private static final SdkField<String> CLIENT_CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientCertificateId").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::clientCertificateId)).setter(AwsApiGatewayV2StageDetails.setter(Builder::clientCertificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCertificateId").build()}).build();
    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedDate").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::createdDate)).setter(AwsApiGatewayV2StageDetails.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::description)).setter(AwsApiGatewayV2StageDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<AwsApiGatewayV2RouteSettings> DEFAULT_ROUTE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultRouteSettings").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::defaultRouteSettings)).setter(AwsApiGatewayV2StageDetails.setter(Builder::defaultRouteSettings)).constructor(AwsApiGatewayV2RouteSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteSettings").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentId").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::deploymentId)).setter(AwsApiGatewayV2StageDetails.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()}).build();
    private static final SdkField<String> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedDate").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::lastUpdatedDate)).setter(AwsApiGatewayV2StageDetails.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDate").build()}).build();
    private static final SdkField<AwsApiGatewayV2RouteSettings> ROUTE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RouteSettings").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::routeSettings)).setter(AwsApiGatewayV2StageDetails.setter(Builder::routeSettings)).constructor(AwsApiGatewayV2RouteSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSettings").build()}).build();
    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StageName").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::stageName)).setter(AwsApiGatewayV2StageDetails.setter(Builder::stageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()}).build();
    private static final SdkField<Map<String, String>> STAGE_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("StageVariables").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::stageVariables)).setter(AwsApiGatewayV2StageDetails.setter(Builder::stageVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AwsApiGatewayAccessLogSettings> ACCESS_LOG_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessLogSettings").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::accessLogSettings)).setter(AwsApiGatewayV2StageDetails.setter(Builder::accessLogSettings)).constructor(AwsApiGatewayAccessLogSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLogSettings").build()}).build();
    private static final SdkField<Boolean> AUTO_DEPLOY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoDeploy").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::autoDeploy)).setter(AwsApiGatewayV2StageDetails.setter(Builder::autoDeploy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeploy").build()}).build();
    private static final SdkField<String> LAST_DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastDeploymentStatusMessage").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::lastDeploymentStatusMessage)).setter(AwsApiGatewayV2StageDetails.setter(Builder::lastDeploymentStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastDeploymentStatusMessage").build()}).build();
    private static final SdkField<Boolean> API_GATEWAY_MANAGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApiGatewayManaged").getter(AwsApiGatewayV2StageDetails.getter(AwsApiGatewayV2StageDetails::apiGatewayManaged)).setter(AwsApiGatewayV2StageDetails.setter(Builder::apiGatewayManaged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiGatewayManaged").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_CERTIFICATE_ID_FIELD, CREATED_DATE_FIELD, DESCRIPTION_FIELD, DEFAULT_ROUTE_SETTINGS_FIELD, DEPLOYMENT_ID_FIELD, LAST_UPDATED_DATE_FIELD, ROUTE_SETTINGS_FIELD, STAGE_NAME_FIELD, STAGE_VARIABLES_FIELD, ACCESS_LOG_SETTINGS_FIELD, AUTO_DEPLOY_FIELD, LAST_DEPLOYMENT_STATUS_MESSAGE_FIELD, API_GATEWAY_MANAGED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClientCertificateId", CLIENT_CERTIFICATE_ID_FIELD);
            this.put("CreatedDate", CREATED_DATE_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("DefaultRouteSettings", DEFAULT_ROUTE_SETTINGS_FIELD);
            this.put("DeploymentId", DEPLOYMENT_ID_FIELD);
            this.put("LastUpdatedDate", LAST_UPDATED_DATE_FIELD);
            this.put("RouteSettings", ROUTE_SETTINGS_FIELD);
            this.put("StageName", STAGE_NAME_FIELD);
            this.put("StageVariables", STAGE_VARIABLES_FIELD);
            this.put("AccessLogSettings", ACCESS_LOG_SETTINGS_FIELD);
            this.put("AutoDeploy", AUTO_DEPLOY_FIELD);
            this.put("LastDeploymentStatusMessage", LAST_DEPLOYMENT_STATUS_MESSAGE_FIELD);
            this.put("ApiGatewayManaged", API_GATEWAY_MANAGED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String clientCertificateId;
    private final String createdDate;
    private final String description;
    private final AwsApiGatewayV2RouteSettings defaultRouteSettings;
    private final String deploymentId;
    private final String lastUpdatedDate;
    private final AwsApiGatewayV2RouteSettings routeSettings;
    private final String stageName;
    private final Map<String, String> stageVariables;
    private final AwsApiGatewayAccessLogSettings accessLogSettings;
    private final Boolean autoDeploy;
    private final String lastDeploymentStatusMessage;
    private final Boolean apiGatewayManaged;

    private AwsApiGatewayV2StageDetails(BuilderImpl builder) {
        this.clientCertificateId = builder.clientCertificateId;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.defaultRouteSettings = builder.defaultRouteSettings;
        this.deploymentId = builder.deploymentId;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.routeSettings = builder.routeSettings;
        this.stageName = builder.stageName;
        this.stageVariables = builder.stageVariables;
        this.accessLogSettings = builder.accessLogSettings;
        this.autoDeploy = builder.autoDeploy;
        this.lastDeploymentStatusMessage = builder.lastDeploymentStatusMessage;
        this.apiGatewayManaged = builder.apiGatewayManaged;
    }

    public final String clientCertificateId() {
        return this.clientCertificateId;
    }

    public final String createdDate() {
        return this.createdDate;
    }

    public final String description() {
        return this.description;
    }

    public final AwsApiGatewayV2RouteSettings defaultRouteSettings() {
        return this.defaultRouteSettings;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final AwsApiGatewayV2RouteSettings routeSettings() {
        return this.routeSettings;
    }

    public final String stageName() {
        return this.stageName;
    }

    public final boolean hasStageVariables() {
        return this.stageVariables != null && !(this.stageVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> stageVariables() {
        return this.stageVariables;
    }

    public final AwsApiGatewayAccessLogSettings accessLogSettings() {
        return this.accessLogSettings;
    }

    public final Boolean autoDeploy() {
        return this.autoDeploy;
    }

    public final String lastDeploymentStatusMessage() {
        return this.lastDeploymentStatusMessage;
    }

    public final Boolean apiGatewayManaged() {
        return this.apiGatewayManaged;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRouteSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStageVariables() ? this.stageVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLogSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDeploy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDeploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiGatewayManaged());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiGatewayV2StageDetails)) {
            return false;
        }
        AwsApiGatewayV2StageDetails other = (AwsApiGatewayV2StageDetails)obj;
        return Objects.equals(this.clientCertificateId(), other.clientCertificateId()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.defaultRouteSettings(), other.defaultRouteSettings()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.routeSettings(), other.routeSettings()) && Objects.equals(this.stageName(), other.stageName()) && this.hasStageVariables() == other.hasStageVariables() && Objects.equals(this.stageVariables(), other.stageVariables()) && Objects.equals(this.accessLogSettings(), other.accessLogSettings()) && Objects.equals(this.autoDeploy(), other.autoDeploy()) && Objects.equals(this.lastDeploymentStatusMessage(), other.lastDeploymentStatusMessage()) && Objects.equals(this.apiGatewayManaged(), other.apiGatewayManaged());
    }

    public final String toString() {
        return ToString.builder((String)"AwsApiGatewayV2StageDetails").add("ClientCertificateId", (Object)this.clientCertificateId()).add("CreatedDate", (Object)this.createdDate()).add("Description", (Object)this.description()).add("DefaultRouteSettings", (Object)this.defaultRouteSettings()).add("DeploymentId", (Object)this.deploymentId()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("RouteSettings", (Object)this.routeSettings()).add("StageName", (Object)this.stageName()).add("StageVariables", this.hasStageVariables() ? this.stageVariables() : null).add("AccessLogSettings", (Object)this.accessLogSettings()).add("AutoDeploy", (Object)this.autoDeploy()).add("LastDeploymentStatusMessage", (Object)this.lastDeploymentStatusMessage()).add("ApiGatewayManaged", (Object)this.apiGatewayManaged()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientCertificateId": {
                return Optional.ofNullable(clazz.cast(this.clientCertificateId()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefaultRouteSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultRouteSettings()));
            }
            case "DeploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "LastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "RouteSettings": {
                return Optional.ofNullable(clazz.cast(this.routeSettings()));
            }
            case "StageName": {
                return Optional.ofNullable(clazz.cast(this.stageName()));
            }
            case "StageVariables": {
                return Optional.ofNullable(clazz.cast(this.stageVariables()));
            }
            case "AccessLogSettings": {
                return Optional.ofNullable(clazz.cast(this.accessLogSettings()));
            }
            case "AutoDeploy": {
                return Optional.ofNullable(clazz.cast(this.autoDeploy()));
            }
            case "LastDeploymentStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.lastDeploymentStatusMessage()));
            }
            case "ApiGatewayManaged": {
                return Optional.ofNullable(clazz.cast(this.apiGatewayManaged()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiGatewayV2StageDetails, T> g) {
        return obj -> g.apply((AwsApiGatewayV2StageDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientCertificateId;
        private String createdDate;
        private String description;
        private AwsApiGatewayV2RouteSettings defaultRouteSettings;
        private String deploymentId;
        private String lastUpdatedDate;
        private AwsApiGatewayV2RouteSettings routeSettings;
        private String stageName;
        private Map<String, String> stageVariables = DefaultSdkAutoConstructMap.getInstance();
        private AwsApiGatewayAccessLogSettings accessLogSettings;
        private Boolean autoDeploy;
        private String lastDeploymentStatusMessage;
        private Boolean apiGatewayManaged;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiGatewayV2StageDetails model) {
            this.clientCertificateId(model.clientCertificateId);
            this.createdDate(model.createdDate);
            this.description(model.description);
            this.defaultRouteSettings(model.defaultRouteSettings);
            this.deploymentId(model.deploymentId);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.routeSettings(model.routeSettings);
            this.stageName(model.stageName);
            this.stageVariables(model.stageVariables);
            this.accessLogSettings(model.accessLogSettings);
            this.autoDeploy(model.autoDeploy);
            this.lastDeploymentStatusMessage(model.lastDeploymentStatusMessage);
            this.apiGatewayManaged(model.apiGatewayManaged);
        }

        public final String getClientCertificateId() {
            return this.clientCertificateId;
        }

        public final void setClientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
        }

        @Override
        public final Builder clientCertificateId(String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        public final String getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AwsApiGatewayV2RouteSettings.Builder getDefaultRouteSettings() {
            return this.defaultRouteSettings != null ? this.defaultRouteSettings.toBuilder() : null;
        }

        public final void setDefaultRouteSettings(AwsApiGatewayV2RouteSettings.BuilderImpl defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings != null ? defaultRouteSettings.build() : null;
        }

        @Override
        public final Builder defaultRouteSettings(AwsApiGatewayV2RouteSettings defaultRouteSettings) {
            this.defaultRouteSettings = defaultRouteSettings;
            return this;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(String lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final AwsApiGatewayV2RouteSettings.Builder getRouteSettings() {
            return this.routeSettings != null ? this.routeSettings.toBuilder() : null;
        }

        public final void setRouteSettings(AwsApiGatewayV2RouteSettings.BuilderImpl routeSettings) {
            this.routeSettings = routeSettings != null ? routeSettings.build() : null;
        }

        @Override
        public final Builder routeSettings(AwsApiGatewayV2RouteSettings routeSettings) {
            this.routeSettings = routeSettings;
            return this;
        }

        public final String getStageName() {
            return this.stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final Map<String, String> getStageVariables() {
            if (this.stageVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.stageVariables;
        }

        public final void setStageVariables(Map<String, String> stageVariables) {
            this.stageVariables = FieldMapCopier.copy(stageVariables);
        }

        @Override
        public final Builder stageVariables(Map<String, String> stageVariables) {
            this.stageVariables = FieldMapCopier.copy(stageVariables);
            return this;
        }

        public final AwsApiGatewayAccessLogSettings.Builder getAccessLogSettings() {
            return this.accessLogSettings != null ? this.accessLogSettings.toBuilder() : null;
        }

        public final void setAccessLogSettings(AwsApiGatewayAccessLogSettings.BuilderImpl accessLogSettings) {
            this.accessLogSettings = accessLogSettings != null ? accessLogSettings.build() : null;
        }

        @Override
        public final Builder accessLogSettings(AwsApiGatewayAccessLogSettings accessLogSettings) {
            this.accessLogSettings = accessLogSettings;
            return this;
        }

        public final Boolean getAutoDeploy() {
            return this.autoDeploy;
        }

        public final void setAutoDeploy(Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
        }

        @Override
        public final Builder autoDeploy(Boolean autoDeploy) {
            this.autoDeploy = autoDeploy;
            return this;
        }

        public final String getLastDeploymentStatusMessage() {
            return this.lastDeploymentStatusMessage;
        }

        public final void setLastDeploymentStatusMessage(String lastDeploymentStatusMessage) {
            this.lastDeploymentStatusMessage = lastDeploymentStatusMessage;
        }

        @Override
        public final Builder lastDeploymentStatusMessage(String lastDeploymentStatusMessage) {
            this.lastDeploymentStatusMessage = lastDeploymentStatusMessage;
            return this;
        }

        public final Boolean getApiGatewayManaged() {
            return this.apiGatewayManaged;
        }

        public final void setApiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
        }

        @Override
        public final Builder apiGatewayManaged(Boolean apiGatewayManaged) {
            this.apiGatewayManaged = apiGatewayManaged;
            return this;
        }

        public AwsApiGatewayV2StageDetails build() {
            return new AwsApiGatewayV2StageDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsApiGatewayV2StageDetails> {
        public Builder clientCertificateId(String var1);

        public Builder createdDate(String var1);

        public Builder description(String var1);

        public Builder defaultRouteSettings(AwsApiGatewayV2RouteSettings var1);

        default public Builder defaultRouteSettings(Consumer<AwsApiGatewayV2RouteSettings.Builder> defaultRouteSettings) {
            return this.defaultRouteSettings((AwsApiGatewayV2RouteSettings)((AwsApiGatewayV2RouteSettings.Builder)AwsApiGatewayV2RouteSettings.builder().applyMutation(defaultRouteSettings)).build());
        }

        public Builder deploymentId(String var1);

        public Builder lastUpdatedDate(String var1);

        public Builder routeSettings(AwsApiGatewayV2RouteSettings var1);

        default public Builder routeSettings(Consumer<AwsApiGatewayV2RouteSettings.Builder> routeSettings) {
            return this.routeSettings((AwsApiGatewayV2RouteSettings)((AwsApiGatewayV2RouteSettings.Builder)AwsApiGatewayV2RouteSettings.builder().applyMutation(routeSettings)).build());
        }

        public Builder stageName(String var1);

        public Builder stageVariables(Map<String, String> var1);

        public Builder accessLogSettings(AwsApiGatewayAccessLogSettings var1);

        default public Builder accessLogSettings(Consumer<AwsApiGatewayAccessLogSettings.Builder> accessLogSettings) {
            return this.accessLogSettings((AwsApiGatewayAccessLogSettings)((AwsApiGatewayAccessLogSettings.Builder)AwsApiGatewayAccessLogSettings.builder().applyMutation(accessLogSettings)).build());
        }

        public Builder autoDeploy(Boolean var1);

        public Builder lastDeploymentStatusMessage(String var1);

        public Builder apiGatewayManaged(Boolean var1);
    }
}

