/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakermetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakermetrics.model.MetricQueryResultStatus;
import software.amazon.awssdk.services.sagemakermetrics.model.MetricValuesCopier;
import software.amazon.awssdk.services.sagemakermetrics.model.XAxisValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricQueryResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricQueryResult> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MetricQueryResult.getter(MetricQueryResult::statusAsString)).setter(MetricQueryResult.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(MetricQueryResult.getter(MetricQueryResult::message)).setter(MetricQueryResult.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<List<Long>> X_AXIS_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("XAxisValues").getter(MetricQueryResult.getter(MetricQueryResult::xAxisValues)).setter(MetricQueryResult.setter(Builder::xAxisValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XAxisValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LONG).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> METRIC_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricValues").getter(MetricQueryResult.getter(MetricQueryResult::metricValues)).setter(MetricQueryResult.setter(Builder::metricValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, MESSAGE_FIELD, X_AXIS_VALUES_FIELD, METRIC_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Status", STATUS_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("XAxisValues", X_AXIS_VALUES_FIELD);
            this.put("MetricValues", METRIC_VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String message;
    private final List<Long> xAxisValues;
    private final List<Double> metricValues;

    private MetricQueryResult(BuilderImpl builder) {
        this.status = builder.status;
        this.message = builder.message;
        this.xAxisValues = builder.xAxisValues;
        this.metricValues = builder.metricValues;
    }

    public final MetricQueryResultStatus status() {
        return MetricQueryResultStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasXAxisValues() {
        return this.xAxisValues != null && !(this.xAxisValues instanceof SdkAutoConstructList);
    }

    public final List<Long> xAxisValues() {
        return this.xAxisValues;
    }

    public final boolean hasMetricValues() {
        return this.metricValues != null && !(this.metricValues instanceof SdkAutoConstructList);
    }

    public final List<Double> metricValues() {
        return this.metricValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasXAxisValues() ? this.xAxisValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricValues() ? this.metricValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricQueryResult)) {
            return false;
        }
        MetricQueryResult other = (MetricQueryResult)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.message(), other.message()) && this.hasXAxisValues() == other.hasXAxisValues() && Objects.equals(this.xAxisValues(), other.xAxisValues()) && this.hasMetricValues() == other.hasMetricValues() && Objects.equals(this.metricValues(), other.metricValues());
    }

    public final String toString() {
        return ToString.builder((String)"MetricQueryResult").add("Status", (Object)this.statusAsString()).add("Message", (Object)this.message()).add("XAxisValues", this.hasXAxisValues() ? this.xAxisValues() : null).add("MetricValues", this.hasMetricValues() ? this.metricValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "XAxisValues": {
                return Optional.ofNullable(clazz.cast(this.xAxisValues()));
            }
            case "MetricValues": {
                return Optional.ofNullable(clazz.cast(this.metricValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetricQueryResult, T> g) {
        return obj -> g.apply((MetricQueryResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String message;
        private List<Long> xAxisValues = DefaultSdkAutoConstructList.getInstance();
        private List<Double> metricValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricQueryResult model) {
            this.status(model.status);
            this.message(model.message);
            this.xAxisValues(model.xAxisValues);
            this.metricValues(model.metricValues);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MetricQueryResultStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Collection<Long> getXAxisValues() {
            if (this.xAxisValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.xAxisValues;
        }

        public final void setXAxisValues(Collection<Long> xAxisValues) {
            this.xAxisValues = XAxisValuesCopier.copy(xAxisValues);
        }

        @Override
        public final Builder xAxisValues(Collection<Long> xAxisValues) {
            this.xAxisValues = XAxisValuesCopier.copy(xAxisValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder xAxisValues(Long ... xAxisValues) {
            this.xAxisValues(Arrays.asList(xAxisValues));
            return this;
        }

        public final Collection<Double> getMetricValues() {
            if (this.metricValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricValues;
        }

        public final void setMetricValues(Collection<Double> metricValues) {
            this.metricValues = MetricValuesCopier.copy(metricValues);
        }

        @Override
        public final Builder metricValues(Collection<Double> metricValues) {
            this.metricValues = MetricValuesCopier.copy(metricValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricValues(Double ... metricValues) {
            this.metricValues(Arrays.asList(metricValues));
            return this;
        }

        public MetricQueryResult build() {
            return new MetricQueryResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricQueryResult> {
        public Builder status(String var1);

        public Builder status(MetricQueryResultStatus var1);

        public Builder message(String var1);

        public Builder xAxisValues(Collection<Long> var1);

        public Builder xAxisValues(Long ... var1);

        public Builder metricValues(Collection<Double> var1);

        public Builder metricValues(Double ... var1);
    }
}

