/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemakergeospatial.model.SageMakerGeospatialResponse;
import software.amazon.awssdk.services.sagemakergeospatial.model.TagsCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobErrorDetails;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobExportErrorDetails;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobExportStatus;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobInputConfig;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobStatus;
import software.amazon.awssdk.services.sagemakergeospatial.model.VectorEnrichmentJobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetVectorEnrichmentJobResponse
extends SageMakerGeospatialResponse
implements ToCopyableBuilder<Builder, GetVectorEnrichmentJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::arn)).setter(GetVectorEnrichmentJobResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::creationTime)).setter(GetVectorEnrichmentJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Integer> DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DurationInSeconds").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::durationInSeconds)).setter(GetVectorEnrichmentJobResponse.setter(Builder::durationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationInSeconds").build()}).build();
    private static final SdkField<VectorEnrichmentJobErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorDetails").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::errorDetails)).setter(GetVectorEnrichmentJobResponse.setter(Builder::errorDetails)).constructor(VectorEnrichmentJobErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::executionRoleArn)).setter(GetVectorEnrichmentJobResponse.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<VectorEnrichmentJobExportErrorDetails> EXPORT_ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportErrorDetails").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::exportErrorDetails)).setter(GetVectorEnrichmentJobResponse.setter(Builder::exportErrorDetails)).constructor(VectorEnrichmentJobExportErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportErrorDetails").build()}).build();
    private static final SdkField<String> EXPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportStatus").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::exportStatusAsString)).setter(GetVectorEnrichmentJobResponse.setter(Builder::exportStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportStatus").build()}).build();
    private static final SdkField<VectorEnrichmentJobInputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::inputConfig)).setter(GetVectorEnrichmentJobResponse.setter(Builder::inputConfig)).constructor(VectorEnrichmentJobInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<VectorEnrichmentJobConfig> JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JobConfig").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::jobConfig)).setter(GetVectorEnrichmentJobResponse.setter(Builder::jobConfig)).constructor(VectorEnrichmentJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::kmsKeyId)).setter(GetVectorEnrichmentJobResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::name)).setter(GetVectorEnrichmentJobResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::statusAsString)).setter(GetVectorEnrichmentJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::tags)).setter(GetVectorEnrichmentJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetVectorEnrichmentJobResponse.getter(GetVectorEnrichmentJobResponse::typeAsString)).setter(GetVectorEnrichmentJobResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, DURATION_IN_SECONDS_FIELD, ERROR_DETAILS_FIELD, EXECUTION_ROLE_ARN_FIELD, EXPORT_ERROR_DETAILS_FIELD, EXPORT_STATUS_FIELD, INPUT_CONFIG_FIELD, JOB_CONFIG_FIELD, KMS_KEY_ID_FIELD, NAME_FIELD, STATUS_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("DurationInSeconds", DURATION_IN_SECONDS_FIELD);
            this.put("ErrorDetails", ERROR_DETAILS_FIELD);
            this.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
            this.put("ExportErrorDetails", EXPORT_ERROR_DETAILS_FIELD);
            this.put("ExportStatus", EXPORT_STATUS_FIELD);
            this.put("InputConfig", INPUT_CONFIG_FIELD);
            this.put("JobConfig", JOB_CONFIG_FIELD);
            this.put("KmsKeyId", KMS_KEY_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("Type", TYPE_FIELD);
        }
    });
    private final String arn;
    private final Instant creationTime;
    private final Integer durationInSeconds;
    private final VectorEnrichmentJobErrorDetails errorDetails;
    private final String executionRoleArn;
    private final VectorEnrichmentJobExportErrorDetails exportErrorDetails;
    private final String exportStatus;
    private final VectorEnrichmentJobInputConfig inputConfig;
    private final VectorEnrichmentJobConfig jobConfig;
    private final String kmsKeyId;
    private final String name;
    private final String status;
    private final Map<String, String> tags;
    private final String type;

    private GetVectorEnrichmentJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.durationInSeconds = builder.durationInSeconds;
        this.errorDetails = builder.errorDetails;
        this.executionRoleArn = builder.executionRoleArn;
        this.exportErrorDetails = builder.exportErrorDetails;
        this.exportStatus = builder.exportStatus;
        this.inputConfig = builder.inputConfig;
        this.jobConfig = builder.jobConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Integer durationInSeconds() {
        return this.durationInSeconds;
    }

    public final VectorEnrichmentJobErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final VectorEnrichmentJobExportErrorDetails exportErrorDetails() {
        return this.exportErrorDetails;
    }

    public final VectorEnrichmentJobExportStatus exportStatus() {
        return VectorEnrichmentJobExportStatus.fromValue(this.exportStatus);
    }

    public final String exportStatusAsString() {
        return this.exportStatus;
    }

    public final VectorEnrichmentJobInputConfig inputConfig() {
        return this.inputConfig;
    }

    public final VectorEnrichmentJobConfig jobConfig() {
        return this.jobConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String name() {
        return this.name;
    }

    public final VectorEnrichmentJobStatus status() {
        return VectorEnrichmentJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final VectorEnrichmentJobType type() {
        return VectorEnrichmentJobType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportErrorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVectorEnrichmentJobResponse)) {
            return false;
        }
        GetVectorEnrichmentJobResponse other = (GetVectorEnrichmentJobResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.durationInSeconds(), other.durationInSeconds()) && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.exportErrorDetails(), other.exportErrorDetails()) && Objects.equals(this.exportStatusAsString(), other.exportStatusAsString()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.jobConfig(), other.jobConfig()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetVectorEnrichmentJobResponse").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("DurationInSeconds", (Object)this.durationInSeconds()).add("ErrorDetails", (Object)this.errorDetails()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ExportErrorDetails", (Object)this.exportErrorDetails()).add("ExportStatus", (Object)this.exportStatusAsString()).add("InputConfig", (Object)this.inputConfig()).add("JobConfig", (Object)this.jobConfig()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "DurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationInSeconds()));
            }
            case "ErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "ExportErrorDetails": {
                return Optional.ofNullable(clazz.cast(this.exportErrorDetails()));
            }
            case "ExportStatus": {
                return Optional.ofNullable(clazz.cast(this.exportStatusAsString()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "JobConfig": {
                return Optional.ofNullable(clazz.cast(this.jobConfig()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetVectorEnrichmentJobResponse, T> g) {
        return obj -> g.apply((GetVectorEnrichmentJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerGeospatialResponse.BuilderImpl
    implements Builder {
        private String arn;
        private Instant creationTime;
        private Integer durationInSeconds;
        private VectorEnrichmentJobErrorDetails errorDetails;
        private String executionRoleArn;
        private VectorEnrichmentJobExportErrorDetails exportErrorDetails;
        private String exportStatus;
        private VectorEnrichmentJobInputConfig inputConfig;
        private VectorEnrichmentJobConfig jobConfig;
        private String kmsKeyId;
        private String name;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVectorEnrichmentJobResponse model) {
            super(model);
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.durationInSeconds(model.durationInSeconds);
            this.errorDetails(model.errorDetails);
            this.executionRoleArn(model.executionRoleArn);
            this.exportErrorDetails(model.exportErrorDetails);
            this.exportStatus(model.exportStatus);
            this.inputConfig(model.inputConfig);
            this.jobConfig(model.jobConfig);
            this.kmsKeyId(model.kmsKeyId);
            this.name(model.name);
            this.status(model.status);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getDurationInSeconds() {
            return this.durationInSeconds;
        }

        public final void setDurationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
        }

        @Override
        public final Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            return this;
        }

        public final VectorEnrichmentJobErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(VectorEnrichmentJobErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(VectorEnrichmentJobErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final VectorEnrichmentJobExportErrorDetails.Builder getExportErrorDetails() {
            return this.exportErrorDetails != null ? this.exportErrorDetails.toBuilder() : null;
        }

        public final void setExportErrorDetails(VectorEnrichmentJobExportErrorDetails.BuilderImpl exportErrorDetails) {
            this.exportErrorDetails = exportErrorDetails != null ? exportErrorDetails.build() : null;
        }

        @Override
        public final Builder exportErrorDetails(VectorEnrichmentJobExportErrorDetails exportErrorDetails) {
            this.exportErrorDetails = exportErrorDetails;
            return this;
        }

        public final String getExportStatus() {
            return this.exportStatus;
        }

        public final void setExportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
        }

        @Override
        public final Builder exportStatus(String exportStatus) {
            this.exportStatus = exportStatus;
            return this;
        }

        @Override
        public final Builder exportStatus(VectorEnrichmentJobExportStatus exportStatus) {
            this.exportStatus(exportStatus == null ? null : exportStatus.toString());
            return this;
        }

        public final VectorEnrichmentJobInputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(VectorEnrichmentJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(VectorEnrichmentJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final VectorEnrichmentJobConfig.Builder getJobConfig() {
            return this.jobConfig != null ? this.jobConfig.toBuilder() : null;
        }

        public final void setJobConfig(VectorEnrichmentJobConfig.BuilderImpl jobConfig) {
            this.jobConfig = jobConfig != null ? jobConfig.build() : null;
        }

        @Override
        public final Builder jobConfig(VectorEnrichmentJobConfig jobConfig) {
            this.jobConfig = jobConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VectorEnrichmentJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(VectorEnrichmentJobType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public GetVectorEnrichmentJobResponse build() {
            return new GetVectorEnrichmentJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerGeospatialResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetVectorEnrichmentJobResponse> {
        public Builder arn(String var1);

        public Builder creationTime(Instant var1);

        public Builder durationInSeconds(Integer var1);

        public Builder errorDetails(VectorEnrichmentJobErrorDetails var1);

        default public Builder errorDetails(Consumer<VectorEnrichmentJobErrorDetails.Builder> errorDetails) {
            return this.errorDetails((VectorEnrichmentJobErrorDetails)((VectorEnrichmentJobErrorDetails.Builder)VectorEnrichmentJobErrorDetails.builder().applyMutation(errorDetails)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder exportErrorDetails(VectorEnrichmentJobExportErrorDetails var1);

        default public Builder exportErrorDetails(Consumer<VectorEnrichmentJobExportErrorDetails.Builder> exportErrorDetails) {
            return this.exportErrorDetails((VectorEnrichmentJobExportErrorDetails)((VectorEnrichmentJobExportErrorDetails.Builder)VectorEnrichmentJobExportErrorDetails.builder().applyMutation(exportErrorDetails)).build());
        }

        public Builder exportStatus(String var1);

        public Builder exportStatus(VectorEnrichmentJobExportStatus var1);

        public Builder inputConfig(VectorEnrichmentJobInputConfig var1);

        default public Builder inputConfig(Consumer<VectorEnrichmentJobInputConfig.Builder> inputConfig) {
            return this.inputConfig((VectorEnrichmentJobInputConfig)((VectorEnrichmentJobInputConfig.Builder)VectorEnrichmentJobInputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder jobConfig(VectorEnrichmentJobConfig var1);

        default public Builder jobConfig(Consumer<VectorEnrichmentJobConfig.Builder> jobConfig) {
            return this.jobConfig((VectorEnrichmentJobConfig)((VectorEnrichmentJobConfig.Builder)VectorEnrichmentJobConfig.builder().applyMutation(jobConfig)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(VectorEnrichmentJobStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(VectorEnrichmentJobType var1);
    }
}

