/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary;
import software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PendingDeploymentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PendingDeploymentSummary> {
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointConfigName").getter(PendingDeploymentSummary.getter(PendingDeploymentSummary::endpointConfigName)).setter(PendingDeploymentSummary.setter(Builder::endpointConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build()}).build();
    private static final SdkField<List<PendingProductionVariantSummary>> PRODUCTION_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductionVariants").getter(PendingDeploymentSummary.getter(PendingDeploymentSummary::productionVariants)).setter(PendingDeploymentSummary.setter(Builder::productionVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PendingProductionVariantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(PendingDeploymentSummary.getter(PendingDeploymentSummary::startTime)).setter(PendingDeploymentSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<List<PendingProductionVariantSummary>> SHADOW_PRODUCTION_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ShadowProductionVariants").getter(PendingDeploymentSummary.getter(PendingDeploymentSummary::shadowProductionVariants)).setter(PendingDeploymentSummary.setter(Builder::shadowProductionVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShadowProductionVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PendingProductionVariantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_CONFIG_NAME_FIELD, PRODUCTION_VARIANTS_FIELD, START_TIME_FIELD, SHADOW_PRODUCTION_VARIANTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EndpointConfigName", ENDPOINT_CONFIG_NAME_FIELD);
            this.put("ProductionVariants", PRODUCTION_VARIANTS_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("ShadowProductionVariants", SHADOW_PRODUCTION_VARIANTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String endpointConfigName;
    private final List<PendingProductionVariantSummary> productionVariants;
    private final Instant startTime;
    private final List<PendingProductionVariantSummary> shadowProductionVariants;

    private PendingDeploymentSummary(BuilderImpl builder) {
        this.endpointConfigName = builder.endpointConfigName;
        this.productionVariants = builder.productionVariants;
        this.startTime = builder.startTime;
        this.shadowProductionVariants = builder.shadowProductionVariants;
    }

    public final String endpointConfigName() {
        return this.endpointConfigName;
    }

    public final boolean hasProductionVariants() {
        return this.productionVariants != null && !(this.productionVariants instanceof SdkAutoConstructList);
    }

    public final List<PendingProductionVariantSummary> productionVariants() {
        return this.productionVariants;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final boolean hasShadowProductionVariants() {
        return this.shadowProductionVariants != null && !(this.shadowProductionVariants instanceof SdkAutoConstructList);
    }

    public final List<PendingProductionVariantSummary> shadowProductionVariants() {
        return this.shadowProductionVariants;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductionVariants() ? this.productionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShadowProductionVariants() ? this.shadowProductionVariants() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingDeploymentSummary)) {
            return false;
        }
        PendingDeploymentSummary other = (PendingDeploymentSummary)obj;
        return Objects.equals(this.endpointConfigName(), other.endpointConfigName()) && this.hasProductionVariants() == other.hasProductionVariants() && Objects.equals(this.productionVariants(), other.productionVariants()) && Objects.equals(this.startTime(), other.startTime()) && this.hasShadowProductionVariants() == other.hasShadowProductionVariants() && Objects.equals(this.shadowProductionVariants(), other.shadowProductionVariants());
    }

    public final String toString() {
        return ToString.builder((String)"PendingDeploymentSummary").add("EndpointConfigName", (Object)this.endpointConfigName()).add("ProductionVariants", this.hasProductionVariants() ? this.productionVariants() : null).add("StartTime", (Object)this.startTime()).add("ShadowProductionVariants", this.hasShadowProductionVariants() ? this.shadowProductionVariants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointConfigName": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigName()));
            }
            case "ProductionVariants": {
                return Optional.ofNullable(clazz.cast(this.productionVariants()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "ShadowProductionVariants": {
                return Optional.ofNullable(clazz.cast(this.shadowProductionVariants()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PendingDeploymentSummary, T> g) {
        return obj -> g.apply((PendingDeploymentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointConfigName;
        private List<PendingProductionVariantSummary> productionVariants = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private List<PendingProductionVariantSummary> shadowProductionVariants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PendingDeploymentSummary model) {
            this.endpointConfigName(model.endpointConfigName);
            this.productionVariants(model.productionVariants);
            this.startTime(model.startTime);
            this.shadowProductionVariants(model.shadowProductionVariants);
        }

        public final String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final List<PendingProductionVariantSummary.Builder> getProductionVariants() {
            List<PendingProductionVariantSummary.Builder> result = PendingProductionVariantSummaryListCopier.copyToBuilder(this.productionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductionVariants(Collection<PendingProductionVariantSummary.BuilderImpl> productionVariants) {
            this.productionVariants = PendingProductionVariantSummaryListCopier.copyFromBuilder(productionVariants);
        }

        @Override
        public final Builder productionVariants(Collection<PendingProductionVariantSummary> productionVariants) {
            this.productionVariants = PendingProductionVariantSummaryListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(PendingProductionVariantSummary ... productionVariants) {
            this.productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productionVariants(Consumer<PendingProductionVariantSummary.Builder> ... productionVariants) {
            this.productionVariants(Stream.of(productionVariants).map(c -> (PendingProductionVariantSummary)((PendingProductionVariantSummary.Builder)PendingProductionVariantSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final List<PendingProductionVariantSummary.Builder> getShadowProductionVariants() {
            List<PendingProductionVariantSummary.Builder> result = PendingProductionVariantSummaryListCopier.copyToBuilder(this.shadowProductionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShadowProductionVariants(Collection<PendingProductionVariantSummary.BuilderImpl> shadowProductionVariants) {
            this.shadowProductionVariants = PendingProductionVariantSummaryListCopier.copyFromBuilder(shadowProductionVariants);
        }

        @Override
        public final Builder shadowProductionVariants(Collection<PendingProductionVariantSummary> shadowProductionVariants) {
            this.shadowProductionVariants = PendingProductionVariantSummaryListCopier.copy(shadowProductionVariants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowProductionVariants(PendingProductionVariantSummary ... shadowProductionVariants) {
            this.shadowProductionVariants(Arrays.asList(shadowProductionVariants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shadowProductionVariants(Consumer<PendingProductionVariantSummary.Builder> ... shadowProductionVariants) {
            this.shadowProductionVariants(Stream.of(shadowProductionVariants).map(c -> (PendingProductionVariantSummary)((PendingProductionVariantSummary.Builder)PendingProductionVariantSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PendingDeploymentSummary build() {
            return new PendingDeploymentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PendingDeploymentSummary> {
        public Builder endpointConfigName(String var1);

        public Builder productionVariants(Collection<PendingProductionVariantSummary> var1);

        public Builder productionVariants(PendingProductionVariantSummary ... var1);

        public Builder productionVariants(Consumer<PendingProductionVariantSummary.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder shadowProductionVariants(Collection<PendingProductionVariantSummary> var1);

        public Builder shadowProductionVariants(PendingProductionVariantSummary ... var1);

        public Builder shadowProductionVariants(Consumer<PendingProductionVariantSummary.Builder> ... var1);
    }
}

