/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TrialSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrialsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListTrialsResponse> {
    private static final SdkField<List<TrialSummary>> TRIAL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrialSummaries").getter(ListTrialsResponse.getter(ListTrialsResponse::trialSummaries)).setter(ListTrialsResponse.setter(Builder::trialSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrialsResponse.getter(ListTrialsResponse::nextToken)).setter(ListTrialsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TrialSummaries", TRIAL_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<TrialSummary> trialSummaries;
    private final String nextToken;

    private ListTrialsResponse(BuilderImpl builder) {
        super(builder);
        this.trialSummaries = builder.trialSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTrialSummaries() {
        return this.trialSummaries != null && !(this.trialSummaries instanceof SdkAutoConstructList);
    }

    public final List<TrialSummary> trialSummaries() {
        return this.trialSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrialSummaries() ? this.trialSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrialsResponse)) {
            return false;
        }
        ListTrialsResponse other = (ListTrialsResponse)((Object)obj);
        return this.hasTrialSummaries() == other.hasTrialSummaries() && Objects.equals(this.trialSummaries(), other.trialSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrialsResponse").add("TrialSummaries", this.hasTrialSummaries() ? this.trialSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrialSummaries": {
                return Optional.ofNullable(clazz.cast(this.trialSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTrialsResponse, T> g) {
        return obj -> g.apply((ListTrialsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<TrialSummary> trialSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrialsResponse model) {
            super(model);
            this.trialSummaries(model.trialSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<TrialSummary.Builder> getTrialSummaries() {
            List<TrialSummary.Builder> result = TrialSummariesCopier.copyToBuilder(this.trialSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrialSummaries(Collection<TrialSummary.BuilderImpl> trialSummaries) {
            this.trialSummaries = TrialSummariesCopier.copyFromBuilder(trialSummaries);
        }

        @Override
        public final Builder trialSummaries(Collection<TrialSummary> trialSummaries) {
            this.trialSummaries = TrialSummariesCopier.copy(trialSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialSummaries(TrialSummary ... trialSummaries) {
            this.trialSummaries(Arrays.asList(trialSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialSummaries(Consumer<TrialSummary.Builder> ... trialSummaries) {
            this.trialSummaries(Stream.of(trialSummaries).map(c -> (TrialSummary)((TrialSummary.Builder)TrialSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTrialsResponse build() {
            return new ListTrialsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrialsResponse> {
        public Builder trialSummaries(Collection<TrialSummary> var1);

        public Builder trialSummaries(TrialSummary ... var1);

        public Builder trialSummaries(Consumer<TrialSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

